/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.oauth.client.token.sdk;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

abstract class AbstractClasspathPropertyLoader {
    private final Properties properties;

    public AbstractClasspathPropertyLoader() {
        String filename = this.getPropertyFileName();
        InputStream input = this.getResource(filename);
        if (input == null) {
            input = this.getResource("/" + filename);
        }
        if (input == null) {
            throw new IllegalStateException("Could not locate resource in classpath: " + filename);
        }
        this.properties = new Properties();
        try {
            this.properties.load(input);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private InputStream getResource(String resource) {
        InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        if (input == null) {
            input = AbstractClasspathPropertyLoader.class.getResourceAsStream(resource);
        }
        if (input == null) {
            input = this.getClass().getResourceAsStream(resource);
        }
        return input;
    }

    protected abstract String getPropertyFileName();

    protected final Properties getProperties() {
        return this.properties;
    }
}

