/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.account.securityquestion;

import com.covisint.core.http.service.core.AbstractRealmScopedResource;
import com.covisint.core.http.service.core.ResourceReference;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NonnullElements;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.core.support.primitive.StringSupport;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SecurityQuestionAccount
extends AbstractRealmScopedResource<SecurityQuestionAccount> {
    private static final long serialVersionUID = -4033441032371206142L;
    private List<Question> questions;

    @Nullable
    public List<Question> getQuestions() {
        if (this.questions == null) {
            return null;
        }
        return Collections.unmodifiableList(this.questions);
    }

    @Nonnull
    public SecurityQuestionAccount setQuestions(@Nonnull @NonnullElements List<Question> newQuestions) {
        this.questions = new ArrayList<Question>(newQuestions);
        return this;
    }

    public final String toString() {
        return this.populateToStringHelper(Objects.toStringHelper((Object)((Object)this))).add("questions", this.questions).toString();
    }

    public final int hashCode() {
        return this.getResourceIdentityHashCode();
    }

    public final boolean equals(Object obj) {
        return this.isResourceIdentityEqual(SecurityQuestionAccount.class, obj);
    }

    public static class Question
    implements Serializable {
        private static final long serialVersionUID = -1561782032156473922L;
        private ResourceReference question;
        private String answer;
        private int index;

        public Question() {
        }

        public Question(@Nonnull ResourceReference newQuestion, @Nullable String newAnswer, int newIndex) {
            this.question = newQuestion;
            this.answer = newAnswer;
            this.index = newIndex;
        }

        public static Question withAnswer(@Nonnull @NotEmpty String questionId, @Nullable String answer) {
            return new Question(new ResourceReference(questionId, "securityQuestion"), answer, 0);
        }

        @Nullable
        public ResourceReference getQuestion() {
            return this.question;
        }

        @Nonnull
        public Question setQuestion(@Nonnull ResourceReference newQuestion) {
            this.question = newQuestion;
            return this;
        }

        @Nullable
        public String getAnswer() {
            return this.answer;
        }

        @Nonnull
        public Question setAnswer(@Nullable String newAnswer) {
            this.answer = newAnswer;
            return this;
        }

        public int getIndex() {
            return this.index;
        }

        public Question setIndex(int newIndex) {
            this.index = newIndex;
            return this;
        }

        public String toString() {
            Objects.ToStringHelper questionStringHelper = Objects.toStringHelper((Object)this).add("question", (Object)this.question).add("index", this.index);
            if (StringSupport.trimOrNull((String)this.answer) != null) {
                questionStringHelper.add("answer", (Object)"*******");
            }
            return questionStringHelper.toString();
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.question.getId(), this.index});
        }

        public final boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Question)) {
                return false;
            }
            Question other = (Question)obj;
            return this.question.getId().equals(other.getQuestion().getId()) && this.index == other.getIndex();
        }
    }
}

