/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.account.securityquestion.io.jsonp;

import com.covisint.core.http.service.core.ResourceReference;
import com.covisint.core.http.service.core.io.jsonp.AbstractRealmScopedResourceReader;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.platform.authn.core.account.securityquestion.SecurityQuestionAccount;
import com.covisint.platform.authn.core.util.JsonpSupport;
import com.covisint.platform.authn.core.util.SupportedMediaType;
import com.google.common.net.MediaType;
import java.util.ArrayList;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;

public class SecurityQuestionAccountReader
extends AbstractRealmScopedResourceReader<SecurityQuestionAccount> {
    @Nullable
    private static List<SecurityQuestionAccount.Question> readQuestions(@Nullable JsonArray questionsJsonArray, @Nonnull SecurityQuestionAccount resource) {
        ArrayList<SecurityQuestionAccount.Question> questionsSet = null;
        if (questionsJsonArray != null) {
            questionsSet = new ArrayList<SecurityQuestionAccount.Question>();
            for (int counter = 0; counter < questionsJsonArray.size(); ++counter) {
                JsonObject questionJsonObject = questionsJsonArray.getJsonObject(counter);
                SecurityQuestionAccount.Question question = SecurityQuestionAccountReader.readQuestion(questionJsonObject, resource);
                if (question == null) continue;
                questionsSet.add(question);
            }
        }
        return questionsSet;
    }

    @Nullable
    private static SecurityQuestionAccount.Question readQuestion(@Nullable JsonObject questionJsonObject, @Nonnull SecurityQuestionAccount resource) {
        SecurityQuestionAccount.Question question = null;
        if (questionJsonObject != null) {
            JsonNumber jsonNumber;
            JsonString jsonString;
            ResourceReference questionResourceReference = null;
            String answer = null;
            int index = 0;
            JsonObject selectedQuestionJsonObject = questionJsonObject.getJsonObject("question");
            if (selectedQuestionJsonObject != null) {
                questionResourceReference = SecurityQuestionAccountReader.readResourceReference((JsonObject)selectedQuestionJsonObject);
            }
            if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(jsonString = questionJsonObject.getJsonString("answer")))) {
                answer = jsonString.getString();
            }
            if ((jsonNumber = questionJsonObject.getJsonNumber("index")) != null) {
                index = jsonNumber.intValue();
            }
            question = questionResourceReference != null ? new SecurityQuestionAccount.Question(questionResourceReference, answer, index) : new SecurityQuestionAccount.Question().setAnswer(answer).setIndex(index);
        }
        return question;
    }

    @Nonnull
    protected SecurityQuestionAccount createResource(@Nonnull MediaType mediaType) {
        return new SecurityQuestionAccount();
    }

    @Nonnull
    public final SecurityQuestionAccount readResource(@Nonnull MediaType mediaType, @Nonnull JsonObject json) {
        SecurityQuestionAccount resource = (SecurityQuestionAccount)super.readResource(mediaType, json);
        JsonArray questionsJson = json.getJsonArray("questions");
        List<SecurityQuestionAccount.Question> questions = SecurityQuestionAccountReader.readQuestions(questionsJson, resource);
        if (questions != null) {
            resource.setQuestions(questions);
        }
        return resource;
    }

    public boolean isReadable(@Nonnull MediaType mediaType) {
        return JsonpSupport.isMediaTypeSame(SupportedMediaType.SECURITY_QUESTION_ACCOUNT_MT, mediaType);
    }

    @Nonnull
    public Class<SecurityQuestionAccount> getResourceType() {
        return SecurityQuestionAccount.class;
    }
}

