/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.password;

import com.covisint.core.http.service.core.RealmScopedResource;
import com.covisint.core.support.constraint.Constraints;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.core.support.constraint.Searchable;
import com.covisint.core.support.primitive.StringSupport;
import com.google.common.base.Objects;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;

@MappedSuperclass
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public abstract class AbstractPassword<T extends AbstractPassword>
implements RealmScopedResource {
    public static final long NO_AUTO_UNLOCK = -1L;
    private static final long serialVersionUID = -4137671586176060816L;
    @Column(name="PASSWORD_POLICY_ID", nullable=false, length=36)
    private String passwordPolicyId;
    @Column(name="AUTHN_POLICY_ID", nullable=false, length=36)
    private String authnPolicyId;
    @Searchable(name="realmId")
    @Column(name="REALM", nullable=false, length=25)
    private String realm;
    @Searchable
    @Id
    @Column(name="SUBJECT", nullable=false, length=36)
    private String subject;
    @Column(name="PASSWORD", nullable=false, length=128)
    private String hashedPassword;
    @Column(name="EXPIRATION", nullable=false, precision=19)
    private long expirationInstant;
    @Column(name="LOCKED", nullable=false)
    private boolean isLocked;
    @Column(name="UNLOCK", nullable=false, precision=19)
    private long unlockInstant;
    @Column(name="CREATOR", nullable=false, length=36)
    private String creator;
    @Column(name="CREATION", nullable=false, precision=19)
    private long creationInstant;
    @Transient
    private String currentPassword;
    @Transient
    private String newPassword;

    protected Objects.ToStringHelper populateToStringHelper(Objects.ToStringHelper helper) {
        helper.add("passwordPolicyId", (Object)this.getPasswordPolicyId()).add("authnPolicyId", (Object)this.authnPolicyId).add("version", (Object)this.getVersion()).add("creator", (Object)this.getCreator()).add("creationInstant", this.getCreationInstant()).add("subject", (Object)this.getSubjectId()).add("expirationInstant", this.expirationInstant).add("isLocked", this.isLocked).add("unlockInstant", this.unlockInstant);
        return helper;
    }

    @Nullable
    public String getId() {
        return this.getSubjectId();
    }

    @Nullable
    public String getPasswordPolicyId() {
        return this.passwordPolicyId;
    }

    public T setPasswordPolicyId(@Nonnull @NotEmpty String id) {
        this.passwordPolicyId = id;
        return (T)this;
    }

    @Nullable
    public String getAuthnPolicyId() {
        return this.authnPolicyId;
    }

    public T setAuthnPolicyId(@Nonnull @NotEmpty String id) {
        this.authnPolicyId = id;
        return (T)this;
    }

    public T setRealm(@Nonnull @NotEmpty String resourceRealm) {
        this.realm = resourceRealm;
        return (T)this;
    }

    @Nullable
    public String getSubjectId() {
        return this.subject;
    }

    public T setSubjectId(@Nonnull @NotEmpty String newId) {
        this.subject = newId;
        return (T)this;
    }

    @Nullable
    public String getHashedPassword() {
        return this.hashedPassword;
    }

    public T setHashedPassword(@Nonnull @NotEmpty String password) {
        this.hashedPassword = password;
        return (T)this;
    }

    public boolean isExpired() {
        if (this.expirationInstant > 1L) {
            return this.expirationInstant < System.currentTimeMillis();
        }
        return false;
    }

    public long getExpirationInstant() {
        return this.expirationInstant;
    }

    public T setExpirationInstant(long instant) {
        this.expirationInstant = instant;
        return (T)this;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public T setLocked(boolean locked) {
        this.isLocked = locked;
        return (T)this;
    }

    public long getUnlockInstant() {
        return this.unlockInstant;
    }

    public T setUnlockInstant(long instant) {
        this.unlockInstant = instant;
        return (T)this;
    }

    @Nullable
    public String getCreator() {
        return this.creator;
    }

    public T setCreator(@Nonnull @NotEmpty String id) {
        this.creator = (String)Constraints.isNotNull((Object)StringSupport.trimOrNull((String)id), (String)"Creator's ID cannot be null or empty");
        return (T)this;
    }

    public long getCreationInstant() {
        return this.creationInstant;
    }

    public T setCreationInstant(long instant) {
        this.creationInstant = instant;
        return (T)this;
    }

    @Nullable
    public String getCurrentPassword() {
        return this.currentPassword;
    }

    public T setCurrentPassword(@Nonnull @NotEmpty String password) {
        this.currentPassword = password;
        return (T)this;
    }

    @Nullable
    public String getNewPassword() {
        return this.newPassword;
    }

    public T setNewPassword(@Nonnull @NotEmpty String password) {
        this.newPassword = password;
        return (T)this;
    }

    @Nullable
    public String getRealm() {
        return this.realm;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getId(), this.getVersion()});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractPassword)) {
            return false;
        }
        AbstractPassword otherPassword = (AbstractPassword)obj;
        return Objects.equal((Object)this.getId(), (Object)otherPassword.getId()) && Objects.equal((Object)this.getVersion(), (Object)otherPassword.getVersion());
    }

    @Nullable
    public String getCreatorApplicationId() {
        return null;
    }
}

