/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.password;

import com.covisint.core.support.constraint.Constraints;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.platform.authn.core.password.AbstractPassword;
import com.covisint.platform.authn.core.password.Password;
import com.google.common.base.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

@Entity
@Table(name="password_audit")
@NamedQuery(name="PasswordAudit.findBySubject", query="SELECT pa FROM PasswordAudit pa WHERE pa.subject = :subject AND pa.realm = :realm ORDER BY pa.version desc")
public class PasswordAudit
extends AbstractPassword {
    private static final long serialVersionUID = 4529070973130522358L;
    @Id
    @Column(name="VERSION", nullable=false, precision=10)
    private Long version;

    public PasswordAudit(@Nonnull Password prototype) {
        this.setSubjectId(prototype.getSubjectId());
        this.setLocked(prototype.isLocked());
        this.setUnlockInstant(prototype.getUnlockInstant());
        this.setExpirationInstant(prototype.getExpirationInstant());
        this.setPasswordPolicyId(prototype.getPasswordPolicyId());
        this.setAuthnPolicyId(prototype.getAuthnPolicyId());
        if (prototype.getHashedPassword() != null) {
            this.setHashedPassword(prototype.getHashedPassword());
        }
        if (prototype.getCurrentPassword() != null) {
            this.setCurrentPassword(prototype.getCurrentPassword());
        }
        if (prototype.getNewPassword() != null) {
            this.setNewPassword(prototype.getNewPassword());
        }
        this.setVersion(prototype.getVersion());
        this.setRealm(prototype.getRealm());
        this.setCreator(prototype.getCreator());
        this.setCreationInstant(prototype.getCreationInstant());
    }

    public PasswordAudit() {
    }

    public String toString() {
        return this.populateToStringHelper(Objects.toStringHelper((Object)this)).toString();
    }

    @Nullable
    public Long getVersion() {
        return this.version;
    }

    public PasswordAudit setVersion(@Nonnull Long aVersion) {
        this.version = Constraints.isGreaterThanOrEqual((long)0L, (long)aVersion, (String)"Version may not be negative.");
        return this;
    }
}

