/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.password;

import com.covisint.core.http.service.core.AbstractResource;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.Nullable;
import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;

public final class PasswordBatchUpdateRequest
extends AbstractResource<PasswordBatchUpdateRequest> {
    private static final long serialVersionUID = -3436845622806226157L;
    private long requestInstant = System.currentTimeMillis();
    private Multimap<String, String> authnPolicyIdSubjects = null;
    private Multimap<String, String> passwordPolicyIdSubjects = null;

    public long getRequestInstant() {
        return this.requestInstant;
    }

    public PasswordBatchUpdateRequest setRequestInstant(long instant) {
        this.requestInstant = instant;
        return this;
    }

    @Nullable
    public Multimap<String, String> getAuthnPolicyIdSubjects() {
        return this.authnPolicyIdSubjects;
    }

    public PasswordBatchUpdateRequest addAuthnPolicyIdSubject(@Nonnull @NotEmpty String authnPolicyId, @Nonnull @NotEmpty String subject) {
        if (this.authnPolicyIdSubjects == null) {
            this.authnPolicyIdSubjects = HashMultimap.create();
        }
        this.authnPolicyIdSubjects.put((Object)authnPolicyId, (Object)subject);
        return this;
    }

    public PasswordBatchUpdateRequest addPasswordPolicyIdSubject(@Nonnull @NotEmpty String passwordPolicyId, @Nonnull @NotEmpty String subject) {
        if (this.passwordPolicyIdSubjects == null) {
            this.passwordPolicyIdSubjects = HashMultimap.create();
        }
        this.passwordPolicyIdSubjects.put((Object)passwordPolicyId, (Object)subject);
        return this;
    }

    @Nullable
    public Multimap<String, String> getPasswordPolicyIdSubjects() {
        return this.passwordPolicyIdSubjects;
    }

    public String toString() {
        return this.populateToStringHelper(Objects.toStringHelper((Object)((Object)this))).add("authnPolicyIdSubjects", this.getAuthnPolicyIdSubjects()).toString();
    }

    public int hashCode() {
        return this.getResourceIdentityHashCode();
    }

    public boolean equals(Object obj) {
        return this.isResourceIdentityEqual(PasswordBatchUpdateRequest.class, obj);
    }
}

