/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.password.authenticate;

import com.covisint.core.http.service.core.io.EntityParsingException;
import com.covisint.core.http.service.core.io.EntityReader;
import com.covisint.core.http.service.core.io.EntityReaderException;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.platform.authn.core.password.authenticate.PasswordAuthenticationRequest;
import com.covisint.platform.authn.core.util.JsonpSupport;
import com.covisint.platform.authn.core.util.SupportedMediaType;
import com.google.common.net.MediaType;
import java.io.InputStream;
import java.util.Scanner;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonParsingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordAuthenticationRequestReader
implements EntityReader<PasswordAuthenticationRequest> {
    private final Logger log = LoggerFactory.getLogger(PasswordAuthenticationRequestReader.class);

    protected PasswordAuthenticationRequest readResource(@Nonnull JsonObject reqJson) {
        JsonString stringProperty;
        PasswordAuthenticationRequest authnReq = new PasswordAuthenticationRequest();
        JsonNumber numberProperty = reqJson.getJsonNumber("instant");
        if (numberProperty != null) {
            authnReq.setRequestInstant(numberProperty.longValue());
        }
        if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(stringProperty = reqJson.getJsonString("service")))) {
            authnReq.setRequestorService(stringProperty.getString());
        }
        if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(stringProperty = reqJson.getJsonString("subject")))) {
            authnReq.setSubject(stringProperty.getString());
        }
        if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(stringProperty = reqJson.getJsonString("password")))) {
            authnReq.setPassword(stringProperty.getString());
        }
        if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(stringProperty = reqJson.getJsonString("subjectInet")))) {
            authnReq.setSubjectInetAddress(stringProperty.getString());
        }
        return authnReq;
    }

    @Nonnull
    public Class<PasswordAuthenticationRequest> getResourceType() {
        return PasswordAuthenticationRequest.class;
    }

    public boolean isReadable(@Nonnull MediaType mediaType) {
        return JsonpSupport.isMediaTypeSame(SupportedMediaType.PASSWORD_AUTHN_REQUEST_MT, mediaType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PasswordAuthenticationRequest read(@Nonnull MediaType mediaType, @Nonnull InputStream input) {
        this.log.debug("Preparing to parse JSON data from inputstream");
        try (JsonReader jsonReader = Json.createReader((InputStream)input);){
            JsonStructure json = jsonReader.read();
            if (!JsonValue.ValueType.OBJECT.equals((Object)json.getValueType())) {
                throw new EntityReaderException("Unsupported source JSON type of " + json.getValueType().toString());
            }
            JsonObject reqJson = (JsonObject)json;
            PasswordAuthenticationRequest passwordAuthenticationRequest = this.readResource(reqJson);
            return passwordAuthenticationRequest;
        }
        catch (JsonParsingException e) {
            this.log.debug("Invalid JSON, unable to parse", (Throwable)e);
            throw new EntityParsingException(e.getLocation().getLineNumber(), e.getLocation().getColumnNumber(), (Throwable)e);
        }
        catch (JsonException e) {
            try (Scanner scanner = new Scanner(input);){
                if (!scanner.hasNext()) {
                    PasswordAuthenticationRequest reqJson = new PasswordAuthenticationRequest();
                    return reqJson;
                }
            }
            this.log.debug("Unable to parse JSON", (Throwable)e);
            throw new EntityReaderException("Unable to parse JSON");
        }
    }
}

