/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.password.authenticate;

import com.covisint.core.http.service.core.io.EntityWriter;
import com.covisint.core.http.service.core.io.EntityWriterException;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.platform.authn.core.password.authenticate.PasswordAuthenticationRequestWriter;
import com.covisint.platform.authn.core.password.authenticate.PasswordAuthenticationResponse;
import com.covisint.platform.authn.core.util.JsonpSupport;
import com.covisint.platform.authn.core.util.SupportedMediaType;
import com.google.common.base.Charsets;
import com.google.common.net.MediaType;
import java.io.OutputStream;
import java.util.HashMap;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordAuthenticationResponseWriter
implements EntityWriter<PasswordAuthenticationResponse> {
    private static final PasswordAuthenticationRequestWriter requestCodec = new PasswordAuthenticationRequestWriter();
    private final Logger log = LoggerFactory.getLogger(PasswordAuthenticationResponseWriter.class);

    @Nonnull
    public Class<PasswordAuthenticationResponse> getResourceType() {
        return PasswordAuthenticationResponse.class;
    }

    public boolean isWritable(@Nonnull Class<?> clazz, @Nonnull MediaType mediaType) {
        return JsonpSupport.isMediaTypeSame(SupportedMediaType.PASSWORD_AUTHN_REPONSE_MT, mediaType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MediaType write(@Nonnull MediaType mediaType, @Nonnull PasswordAuthenticationResponse authnResp, @Nonnull OutputStream output) {
        JsonWriterFactory jsonFactory = Json.createWriterFactory(new HashMap());
        try (JsonWriter writer = jsonFactory.createWriter(output, Charsets.UTF_8);){
            this.log.debug("Writing JSON to output stream");
            JsonObjectBuilder json = Json.createObjectBuilder();
            json.add("instant", authnResp.getAuthenticationInstant());
            if (authnResp.getAuthenticationResult() != null) {
                json.add("result", authnResp.getAuthenticationResult().toString());
            }
            if (authnResp.getAuthenticationRequest() != null) {
                json.add("request", requestCodec.writeResource(authnResp.getAuthenticationRequest()));
            }
            writer.write((JsonStructure)json.build());
            MediaType mediaType2 = mediaType;
            return mediaType2;
        }
        catch (IllegalStateException | JsonException e) {
            this.log.debug("Unable to write JSON to output stream", e);
            throw new EntityWriterException("Unable to write JSON");
        }
    }
}

