/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.password.io.jsonp;

import com.covisint.core.http.service.core.io.jsonp.AbstractResourceReader;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.primitive.StringSupport;
import com.covisint.platform.authn.core.password.PasswordBatchUpdateRequest;
import com.covisint.platform.authn.core.util.JsonpSupport;
import com.covisint.platform.authn.core.util.SupportedMediaType;
import com.google.common.net.MediaType;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

public class PasswordBatchUpdateRequestReader
extends AbstractResourceReader<PasswordBatchUpdateRequest> {
    @Nonnull
    protected PasswordBatchUpdateRequest readResource(@Nonnull MediaType mediaType, @Nonnull JsonObject json) {
        JsonObject passwordIdSubjectsProperty;
        JsonObject authnIdSubjectsProperty;
        PasswordBatchUpdateRequest passwordUpdateReq = (PasswordBatchUpdateRequest)super.readResource(mediaType, json);
        JsonNumber numberProperty = json.getJsonNumber("instant");
        if (numberProperty != null) {
            passwordUpdateReq.setRequestInstant(numberProperty.longValue());
        }
        if ((authnIdSubjectsProperty = json.getJsonObject("authnPolicyIdSubjects")) != null) {
            for (String key : authnIdSubjectsProperty.keySet()) {
                if (key == null) continue;
                JsonArray subjects = authnIdSubjectsProperty.getJsonArray(key);
                for (JsonValue subject : subjects) {
                    String subjectValue;
                    if (com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)((JsonString)subject)) || (subjectValue = StringSupport.trimOrNull((String)((JsonString)subject).getString())) == null) continue;
                    passwordUpdateReq.addAuthnPolicyIdSubject(key, subjectValue);
                }
            }
        }
        if ((passwordIdSubjectsProperty = json.getJsonObject("passwordPolicyIdSubjects")) != null) {
            for (String key : passwordIdSubjectsProperty.keySet()) {
                if (key == null) continue;
                JsonArray subjects = passwordIdSubjectsProperty.getJsonArray(key);
                for (JsonValue subject : subjects) {
                    String subjectValue;
                    if (com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)((JsonString)subject)) || (subjectValue = StringSupport.trimOrNull((String)((JsonString)subject).getString())) == null) continue;
                    passwordUpdateReq.addPasswordPolicyIdSubject(key, subjectValue);
                }
            }
        }
        return passwordUpdateReq;
    }

    @Nonnull
    protected PasswordBatchUpdateRequest createResource(@Nonnull MediaType mediaType) {
        return new PasswordBatchUpdateRequest();
    }

    @Nonnull
    public Class<PasswordBatchUpdateRequest> getResourceType() {
        return PasswordBatchUpdateRequest.class;
    }

    public boolean isReadable(@Nonnull MediaType mediaType) {
        return JsonpSupport.isMediaTypeSame(SupportedMediaType.PASSWORD_BATCH_REQUEST_MT, mediaType);
    }
}

