/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.password.policy;

import com.covisint.core.support.constraint.Constraints;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.platform.authn.core.password.policy.AbstractPolicyRule;
import com.covisint.platform.authn.core.password.policy.Operation;
import com.covisint.platform.authn.core.util.LanguageManager;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name="CHARACTER_CLASS_RULE")
@DiscriminatorValue(value="CHARACTER_CLASS")
public class CharacterClassRule
extends AbstractPolicyRule
implements Serializable {
    public static final String RULE_TYPE = "CHARACTER_CLASS";
    private static final long serialVersionUID = 5612869847952875204L;
    @Column(name="NUMBER_REQUIRED", nullable=false, scale=3)
    private int numberRequired;
    @Column(name="LOWERCASE_ALLOWED", nullable=false)
    private boolean lowercaseAllowed;
    @Column(name="UPPERCASE_ALLOWED", nullable=false)
    private boolean uppercaseAllowed;
    @Column(name="NUMBER_ALLOWED", nullable=false)
    private boolean numberAllowed;
    @Column(name="SPECIAL_ALLOWED", nullable=false)
    private boolean specialAllowed;

    public CharacterClassRule() {
        super(RULE_TYPE);
    }

    public int getNumberRequired() {
        return this.numberRequired;
    }

    public void setNumberRequired(int newNumberRequired) {
        int maxCharType = 4;
        if (!this.lowercaseAllowed) {
            --maxCharType;
        }
        if (!this.uppercaseAllowed) {
            --maxCharType;
        }
        if (!this.numberAllowed) {
            --maxCharType;
        }
        if (!this.specialAllowed) {
            --maxCharType;
        }
        this.numberRequired = (int)Constraints.numberInRangeInclusive((long)0L, (long)maxCharType, (long)newNumberRequired, (String)("Number Required must be between 0 and " + maxCharType + "."));
    }

    public boolean isLowercaseAllowed() {
        return this.lowercaseAllowed;
    }

    public void setLowercaseAllowed(boolean newLowercaseAllowed) {
        this.lowercaseAllowed = newLowercaseAllowed;
    }

    public boolean isUppercaseAllowed() {
        return this.uppercaseAllowed;
    }

    public void setUppercaseAllowed(boolean newUppercaseAllowed) {
        this.uppercaseAllowed = newUppercaseAllowed;
    }

    public boolean isNumberAllowed() {
        return this.numberAllowed;
    }

    public void setNumberAllowed(boolean newNumberAllowed) {
        this.numberAllowed = newNumberAllowed;
    }

    public boolean isSpecialAllowed() {
        return this.specialAllowed;
    }

    public void setSpecialAllowed(boolean newSpecialAllowed) {
        this.specialAllowed = newSpecialAllowed;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("numberRequired", this.numberRequired).add("numberAllowed", this.numberAllowed).add("lowercaseAllowed", this.lowercaseAllowed).add("uppercaseAllowed", this.uppercaseAllowed).add("specialAllowed", this.specialAllowed).toString();
    }

    @Override
    @Nonnull
    public String getDescription(List<String> languageTags) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(LanguageManager.getText("PASSWORD_CHARACTER_TYPE", languageTags), this.numberRequired));
        ArrayList<String> allowedDescriptions = new ArrayList<String>();
        if (this.numberAllowed) {
            allowedDescriptions.add(LanguageManager.getText("PASSWORD_NUMBER_ALLOWED", languageTags));
        }
        if (this.lowercaseAllowed) {
            allowedDescriptions.add(LanguageManager.getText("PASSWORD_LOWERCASE_ALLOWED", languageTags));
        }
        if (this.uppercaseAllowed) {
            allowedDescriptions.add(LanguageManager.getText("PASSWORD_UPPERCASE_ALLOWED", languageTags));
        }
        if (this.specialAllowed) {
            allowedDescriptions.add(LanguageManager.getText("PASSWORD_SPECIAL_ALLOWED", languageTags));
        }
        for (int i = 0; i < allowedDescriptions.size(); ++i) {
            if (i == 0) {
                sb.append(" ");
            }
            sb.append((String)allowedDescriptions.get(i));
            if (i == allowedDescriptions.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    @Override
    public EnumSet<Operation> getSupportedOperations() {
        return EnumSet.of(Operation.AUTHENTICATE, Operation.PASSWORD_CHANGE, Operation.PASSWORD_RESET, Operation.PASSWORD_SPECIFY, Operation.EXPIRED_PASSWORD_CHANGE);
    }
}

