/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.password.policy;

import com.covisint.core.support.constraint.Nullable;
import com.covisint.core.support.primitive.StringSupport;
import com.covisint.platform.authn.core.password.policy.AbstractPolicyRule;
import com.covisint.platform.authn.core.password.policy.Operation;
import com.covisint.platform.authn.core.util.LanguageManager;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name="DISALLOWED_CHARACTERS_RULE")
@DiscriminatorValue(value="DISALLOWED_CHARACTERS")
public class DisallowedCharactersRule
extends AbstractPolicyRule
implements Serializable {
    public static final String RULE_TYPE = "DISALLOWED_CHARACTERS";
    private static final long serialVersionUID = 6322861055947240053L;
    @Column(name="DISALLOWED_CHARACTERS", length=64, nullable=false)
    private String disallowedCharacters;

    public DisallowedCharactersRule() {
        super(RULE_TYPE);
    }

    @Nullable
    public String getDisallowedCharacters() {
        return this.disallowedCharacters;
    }

    public void setDisallowedCharacters(String newDisAllowedCharacters) {
        this.disallowedCharacters = StringSupport.trimOrNull((String)newDisAllowedCharacters);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("disallowedCharacters", (Object)this.disallowedCharacters).toString();
    }

    @Override
    public String getDescription(List<String> languageTags) {
        return String.format(LanguageManager.getText("PASSWORD_DISALLOWED_CHARACTERS_DESCRIPTION", languageTags), this.getDisallowedCharacters());
    }

    @Override
    public EnumSet<Operation> getSupportedOperations() {
        return EnumSet.of(Operation.AUTHENTICATE, Operation.PASSWORD_CHANGE, Operation.PASSWORD_RESET, Operation.PASSWORD_SPECIFY, Operation.EXPIRED_PASSWORD_CHANGE);
    }
}

