/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.password.policy;

import com.covisint.core.support.constraint.Constraints;
import com.covisint.platform.authn.core.password.policy.AbstractPolicyRule;
import com.covisint.platform.authn.core.password.policy.Operation;
import com.covisint.platform.authn.core.util.LanguageManager;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name="DISALLOWED_WORD_LIST_RULE")
public class DisallowedWordListRule
extends AbstractPolicyRule
implements Serializable {
    public static final String RULE_TYPE = "DISALLOWED_WORDS";
    private static final long serialVersionUID = -7560951932510458743L;
    @Column(name="WORD_LIST_ID", nullable=false)
    private long wordListId;

    public DisallowedWordListRule() {
        super(RULE_TYPE);
    }

    public long getWordlistId() {
        return this.wordListId;
    }

    public DisallowedWordListRule setWordListId(long id) {
        this.wordListId = Constraints.isGreaterThanOrEqual((long)0L, (long)id, (String)"wordListId must be greater than or equal 0");
        return this;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("wordListId", this.wordListId).toString();
    }

    @Override
    public String getDescription(List<String> languageTags) {
        if (this.wordListId == 0L) {
            return LanguageManager.getText("PASSWORD_DISALLOWED_WORD_LIST_DESCRIPTON_NO", languageTags);
        }
        return LanguageManager.getText("PASSWORD_DISALLOWED_WORD_LIST_DESCRIPTON_YES", languageTags);
    }

    @Override
    public EnumSet<Operation> getSupportedOperations() {
        return EnumSet.of(Operation.AUTHENTICATE, Operation.PASSWORD_CHANGE, Operation.PASSWORD_RESET, Operation.PASSWORD_SPECIFY, Operation.EXPIRED_PASSWORD_CHANGE);
    }
}

