/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.password.policy;

import com.covisint.core.http.service.core.AbstractRealmScopedResource;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.core.support.constraint.Unmodifiable;
import com.covisint.core.support.primitive.StringSupport;
import com.covisint.platform.authn.core.password.policy.AbstractPolicyRule;
import com.covisint.platform.authn.core.password.policy.Status;
import com.google.common.base.Objects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.MapKey;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="password_policy")
@NamedQueries(value={@NamedQuery(name="passwordPolicy.findByName", query="SELECT p FROM PasswordPolicy p where  p.name = :name and p.realm = :realm"), @NamedQuery(name="passwordPolicy.getByStatus", query="SELECT p FROM PasswordPolicy p WHERE p.status = :status and p.realm = :realm")})
public class PasswordPolicy
extends AbstractRealmScopedResource<PasswordPolicy> {
    private static final long serialVersionUID = -187910734703220804L;
    @Column(name="STATUS")
    @Enumerated(value=EnumType.STRING)
    private Status status;
    @Column(name="NAME")
    private String name;
    @Column(name="DESCRIPTION", nullable=true)
    private String description;
    @OneToMany(mappedBy="passwordPolicy", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @MapKey(name="type")
    private Map<String, AbstractPolicyRule> rules = new HashMap<String, AbstractPolicyRule>();

    @Nullable
    public AbstractPolicyRule getRule(String newRuleType) {
        return this.rules.get(newRuleType);
    }

    @Nullable
    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status newStatus) {
        this.status = newStatus;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = StringSupport.trimOrNull((String)newName);
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String newDescription) {
        this.description = StringSupport.trimOrNull((String)newDescription);
    }

    @Unmodifiable
    public Map<String, AbstractPolicyRule> getRules() {
        return Collections.unmodifiableMap(this.rules);
    }

    public void addRule(AbstractPolicyRule rule) {
        if (rule == null) {
            return;
        }
        rule.setPasswordPolicy(this);
        this.rules.put(rule.getType(), rule);
    }

    public void removeRule(String type) {
        String trimmedType = StringSupport.trimOrNull((String)type);
        if (trimmedType == null) {
            return;
        }
        AbstractPolicyRule rule = this.rules.remove(trimmedType);
        if (rule != null) {
            rule.setPasswordPolicy(null);
        }
    }

    public String toString() {
        return this.populateToStringHelper(Objects.toStringHelper((Object)((Object)this))).add("status", (Object)this.status).add("name", (Object)this.name).add("description", (Object)this.description).add("rules", this.rules).toString();
    }

    public int hashCode() {
        return this.getResourceIdentityHashCode();
    }

    public boolean equals(Object obj) {
        return this.isResourceIdentityEqual(PasswordPolicy.class, obj);
    }
}

