/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.password.policy.io.jsonp;

import com.covisint.core.http.service.core.io.EntityWriter;
import com.covisint.core.http.service.core.io.EntityWriterException;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.platform.authn.core.password.policy.AbstractPolicyRule;
import com.google.common.base.Charsets;
import com.google.common.net.MediaType;
import java.io.OutputStream;
import java.util.HashMap;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPasswordPolicyRuleWriter
implements EntityWriter<AbstractPolicyRule> {
    private final Logger log = LoggerFactory.getLogger(AbstractPasswordPolicyRuleWriter.class);

    @Nonnull
    private JsonWriterFactory createWriterFactory(@Nonnull MediaType mediaType) {
        this.log.debug("Creating JSON writer factory");
        HashMap<String, Boolean> writerConfig = new HashMap<String, Boolean>();
        writerConfig.put("javax.json.stream.JsonGenerator.prettyPrinting", false);
        return Json.createWriterFactory(writerConfig);
    }

    protected abstract JsonObjectBuilder writeResource(@Nonnull AbstractPolicyRule var1);

    @Nonnull
    public abstract String getRuleType();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final MediaType write(@Nonnull MediaType mediaType, @Nonnull AbstractPolicyRule source, @Nonnull OutputStream output) {
        if (!this.getResourceType().isAssignableFrom(source.getClass())) {
            throw new EntityWriterException("The server is unable to produce content of type");
        }
        this.log.debug("Preparing to write an object of type {}, into a JSON structure", (Object)source.getClass().getName());
        JsonObjectBuilder builder = this.writeResource(source);
        builder.add("type", source.getType().toLowerCase());
        JsonObject json = builder.build();
        this.log.debug("A JSON structure of type {} was created for an object of type {}", (Object)json.getValueType().toString(), (Object)source.getClass().getName());
        JsonWriterFactory factory = this.createWriterFactory(mediaType);
        try (JsonWriter writer = factory.createWriter(output, Charsets.UTF_8);){
            this.log.debug("Writing JSON to output stream");
            writer.write((JsonStructure)json);
            MediaType mediaType2 = mediaType;
            return mediaType2;
        }
        catch (IllegalStateException | JsonException e) {
            this.log.debug("Unable to write JSON to output stream", e);
            throw new EntityWriterException("Unable to write JSON");
        }
    }

    public final JsonObjectBuilder write(@Nonnull AbstractPolicyRule resource) {
        JsonObjectBuilder builder = this.writeResource(resource);
        builder.add("type", resource.getType().toLowerCase());
        return builder;
    }
}

