/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.password.policy.io.jsonp;

import com.covisint.core.http.service.core.io.EntityReaderException;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.platform.authn.core.password.policy.CharacterClassRule;
import com.covisint.platform.authn.core.password.policy.io.jsonp.AbstractPasswordPolicyRuleReader;
import com.google.common.net.MediaType;
import javax.json.JsonObject;

public final class CharacterClassRuleReader
extends AbstractPasswordPolicyRuleReader {
    @Override
    protected CharacterClassRule createResource(MediaType mediaType) {
        return new CharacterClassRule();
    }

    @Override
    protected CharacterClassRule readResource(@Nonnull JsonObject ruleJson) {
        CharacterClassRule rule = new CharacterClassRule();
        if (!ruleJson.containsKey((Object)"allowUpperChars")) {
            throw new EntityReaderException("JSON object of " + "CHARACTER_CLASS".toLowerCase() + " rule did not contain the required property " + "allowUpperChars");
        }
        rule.setUppercaseAllowed(ruleJson.getBoolean("allowUpperChars"));
        if (!ruleJson.containsKey((Object)"allowLowerChars")) {
            throw new EntityReaderException("JSON object of " + "CHARACTER_CLASS".toLowerCase() + " rule did not contain the required property " + "allowLowerChars");
        }
        rule.setLowercaseAllowed(ruleJson.getBoolean("allowLowerChars"));
        if (!ruleJson.containsKey((Object)"allowNumChars")) {
            throw new EntityReaderException("JSON object of " + "CHARACTER_CLASS".toLowerCase() + " rule did not contain the required property " + "allowNumChars");
        }
        rule.setNumberAllowed(ruleJson.getBoolean("allowNumChars"));
        if (!ruleJson.containsKey((Object)"allowSpecialChars")) {
            throw new EntityReaderException("JSON object of " + "CHARACTER_CLASS".toLowerCase() + " rule did not contain the required property " + "allowSpecialChars");
        }
        rule.setSpecialAllowed(ruleJson.getBoolean("allowSpecialChars"));
        if (ruleJson.containsKey((Object)"requiredNumberOfCharClasses")) {
            rule.setNumberRequired(ruleJson.getInt("requiredNumberOfCharClasses"));
        }
        return rule;
    }

    @Nonnull
    public Class getResourceType() {
        return CharacterClassRule.class;
    }

    public boolean isReadable(MediaType mediaType) {
        return true;
    }

    @Override
    public String getRuleType() {
        return "CHARACTER_CLASS";
    }
}

