/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.password.policy.io.jsonp;

import com.covisint.core.http.service.core.io.EntityReaderException;
import com.covisint.core.http.service.core.io.jsonp.JsonpSupport;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.platform.authn.core.password.policy.DisallowedCharactersRule;
import com.covisint.platform.authn.core.password.policy.io.jsonp.AbstractPasswordPolicyRuleReader;
import com.google.common.net.MediaType;
import javax.json.JsonObject;
import javax.json.JsonString;

public final class DisallowedCharactersRuleReader
extends AbstractPasswordPolicyRuleReader {
    @Override
    protected DisallowedCharactersRule readResource(@Nonnull JsonObject ruleJson) {
        DisallowedCharactersRule rule = new DisallowedCharactersRule();
        JsonString jsonString = ruleJson.getJsonString("disallowedChars");
        if (JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)jsonString)) {
            throw new EntityReaderException("JSON object of " + "DISALLOWED_CHARACTERS".toLowerCase() + " rule did not contain the required property " + "disallowedChars");
        }
        rule.setDisallowedCharacters(jsonString.getString());
        return rule;
    }

    @Override
    protected DisallowedCharactersRule createResource(MediaType mediaType) {
        return new DisallowedCharactersRule();
    }

    @Nonnull
    public Class getResourceType() {
        return DisallowedCharactersRule.class;
    }

    public boolean isReadable(MediaType mediaType) {
        return true;
    }

    @Override
    public String getRuleType() {
        return "DISALLOWED_CHARACTERS";
    }
}

