/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.password.policy.io.jsonp;

import com.covisint.core.http.service.core.io.EntityReaderException;
import com.covisint.core.http.service.core.io.jsonp.AbstractRealmScopedResourceReader;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NonnullElements;
import com.covisint.core.support.constraint.Unmodifiable;
import com.covisint.core.support.primitive.StringSupport;
import com.covisint.platform.authn.core.password.policy.PasswordPolicy;
import com.covisint.platform.authn.core.password.policy.Status;
import com.covisint.platform.authn.core.password.policy.io.jsonp.AbstractPasswordPolicyRuleReader;
import com.covisint.platform.authn.core.util.JsonpSupport;
import com.covisint.platform.authn.core.util.SupportedMediaType;
import com.google.common.net.MediaType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordPolicyReader
extends AbstractRealmScopedResourceReader<PasswordPolicy> {
    private final Logger log = LoggerFactory.getLogger(PasswordPolicyReader.class);
    private Map<String, AbstractPasswordPolicyRuleReader> ruleCodecs = Collections.EMPTY_MAP;

    protected void unmarshallRules(@Nonnull JsonArray rulesJson, @Nonnull PasswordPolicy policy) {
        for (JsonValue value : rulesJson) {
            if (!JsonValue.ValueType.OBJECT.equals((Object)value.getValueType())) {
                this.log.debug("skipping unsupported value type");
                continue;
            }
            JsonObject ruleJson = (JsonObject)value;
            JsonString ruleType = ruleJson.getJsonString("type");
            if (ruleType == null) {
                throw new EntityReaderException("Rule object does not contain a type property");
            }
            AbstractPasswordPolicyRuleReader ruleCodec = this.ruleCodecs.get(StringSupport.trimOrEmpty((String)ruleType.getString()).toLowerCase());
            if (ruleCodec == null) {
                throw new EntityReaderException("Rule object type property is null or empty");
            }
            policy.addRule(ruleCodec.readResource(ruleJson));
        }
    }

    @Nonnull
    protected PasswordPolicy readResource(@Nonnull MediaType mediaType, @Nonnull JsonObject policyJson) {
        JsonArray rulesJson;
        PasswordPolicy policy = (PasswordPolicy)super.readResource(mediaType, policyJson);
        JsonString stringProperty = policyJson.getJsonString("status");
        if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)stringProperty)) {
            policy.setStatus(Status.valueOf(stringProperty.getString()));
        }
        if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(stringProperty = policyJson.getJsonString("name")))) {
            policy.setName(stringProperty.getString());
        }
        if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(stringProperty = policyJson.getJsonString("description")))) {
            policy.setDescription(stringProperty.getString());
        }
        if ((rulesJson = policyJson.getJsonArray("rules")) != null) {
            this.log.debug("Unmarshalling policy rules");
            this.unmarshallRules(rulesJson, policy);
        }
        return policy;
    }

    @Nonnull
    protected PasswordPolicy createResource(@Nonnull MediaType mediaType) {
        return new PasswordPolicy();
    }

    @Nonnull
    public Class<PasswordPolicy> getResourceType() {
        return PasswordPolicy.class;
    }

    @Unmodifiable
    @Nonnull
    @NonnullElements
    public Collection<AbstractPasswordPolicyRuleReader> getPasswordPolicyRuleCodecs() {
        return Collections.unmodifiableCollection(this.ruleCodecs.values());
    }

    public void setPasswordPolicyRuleCodecs(Collection<AbstractPasswordPolicyRuleReader> codecs) {
        if (codecs == null) {
            return;
        }
        this.ruleCodecs = new HashMap<String, AbstractPasswordPolicyRuleReader>();
        for (AbstractPasswordPolicyRuleReader codec : codecs) {
            if (codec == null) continue;
            this.ruleCodecs.put(codec.getRuleType().toLowerCase(), codec);
        }
    }

    public boolean isReadable(@Nonnull MediaType mediaType) {
        return JsonpSupport.isMediaTypeSame(SupportedMediaType.PASSWORD_POLICY_MT, mediaType);
    }
}

