/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.password.validation;

import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.Nullable;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PasswordValidationResponse
implements Serializable {
    private static final long serialVersionUID = 4302070215891827784L;
    private List<RuleValidation> ruleValidations = Collections.synchronizedList(new ArrayList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRuleValidation(String ruleType, String ruleDescription, boolean rulePassed) {
        List<RuleValidation> list = this.ruleValidations;
        synchronized (list) {
            this.ruleValidations.add(new RuleValidation(ruleType, ruleDescription, rulePassed));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<RuleValidation> getRuleValidations() {
        List<RuleValidation> list = this.ruleValidations;
        synchronized (list) {
            return Collections.unmodifiableList(this.ruleValidations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allPassed() {
        List<RuleValidation> list = this.ruleValidations;
        synchronized (list) {
            for (RuleValidation rule : this.ruleValidations) {
                if (rule.isPassed()) continue;
                return false;
            }
            return true;
        }
    }

    public String toString() {
        StringBuilder response = new StringBuilder();
        for (RuleValidation rule : this.ruleValidations) {
            response.append(rule.getType() + ": " + rule.isPassed() + "-" + rule.getDescription() + "\n");
        }
        return response.toString();
    }

    public final class RuleValidation
    implements Serializable {
        private static final long serialVersionUID = 477136179091510868L;
        private final String type;
        private final String description;
        private final boolean passed;

        public RuleValidation(@Nonnull @NotEmpty String ruleType, String ruleDescription, boolean rulePassed) {
            this.type = ruleType;
            this.description = ruleDescription;
            this.passed = rulePassed;
        }

        @Nonnull
        @NotEmpty
        public final String getType() {
            return this.type;
        }

        @Nonnull
        @NotEmpty
        public String getDescription() {
            return this.description;
        }

        public boolean isPassed() {
            return this.passed;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.description, this.passed, this.type});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RuleValidation other = (RuleValidation)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return Objects.equal((Object)this.type, (Object)other.type) && Objects.equal((Object)this.description, (Object)other.description) && Objects.equal((Object)this.passed, (Object)other.passed);
        }

        private PasswordValidationResponse getOuterType() {
            return PasswordValidationResponse.this;
        }
    }
}

