/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.policy;

import com.covisint.platform.authn.core.policy.AbstractAuthenticationPolicyRule;
import com.google.common.base.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name="PASS_LOCKOUT_RULE")
public final class PasswordLockoutRule
extends AbstractAuthenticationPolicyRule {
    public static final String RULE_TYPE = "PasswordLockout";
    private static final long serialVersionUID = 5151207513923034869L;
    @Column(name="FAILURES", nullable=false, scale=5)
    private int failuresToLockout = 3;
    @Column(name="FAILURE_WINDOW", nullable=false, scale=5)
    private int failureWindow = 5;
    @Column(name="LOCKOUT_WINDOW", nullable=false, scale=5)
    private int lockoutWindow = 15;

    public PasswordLockoutRule() {
        this.setType(RULE_TYPE);
    }

    public int getFailuresToLockout() {
        return this.failuresToLockout;
    }

    public PasswordLockoutRule setFailuresToLockout(int failures) {
        this.failuresToLockout = failures;
        return this;
    }

    public int getFailureWindow() {
        return this.failureWindow;
    }

    public PasswordLockoutRule setFailureWindow(int failure) {
        this.failureWindow = failure;
        return this;
    }

    public int getLockoutWindow() {
        return this.lockoutWindow;
    }

    public PasswordLockoutRule setLockoutWindow(int window) {
        this.lockoutWindow = window;
        return this;
    }

    public String toString() {
        return this.populateToStringHelper(Objects.toStringHelper((Object)this)).add("failuresToLockout", this.failuresToLockout).add("failureWindow", this.failureWindow).add("lockoutWindow", this.lockoutWindow).toString();
    }
}

