/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.policy.io.jsonp;

import com.covisint.core.http.service.core.io.EntityReaderException;
import com.covisint.core.http.service.core.io.jsonp.AbstractRealmScopedResourceReader;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NonnullElements;
import com.covisint.core.support.constraint.Unmodifiable;
import com.covisint.core.support.primitive.StringSupport;
import com.covisint.platform.authn.core.policy.AbstractAuthenticationPolicyRule;
import com.covisint.platform.authn.core.policy.AuthenticationPolicy;
import com.covisint.platform.authn.core.policy.AuthenticationPolicyStatus;
import com.covisint.platform.authn.core.policy.io.jsonp.AbstractAuthenticationPolicyRuleReader;
import com.covisint.platform.authn.core.util.JsonpSupport;
import com.covisint.platform.authn.core.util.SupportedMediaType;
import com.google.common.net.MediaType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationPolicyReader
extends AbstractRealmScopedResourceReader<AuthenticationPolicy> {
    private final Logger log = LoggerFactory.getLogger(AuthenticationPolicyReader.class);
    private Map<String, AbstractAuthenticationPolicyRuleReader> ruleCodecs = Collections.EMPTY_MAP;

    @Nonnull
    protected AuthenticationPolicy readResource(@Nonnull MediaType mediaType, @Nonnull JsonObject src) {
        JsonArray rulesJson;
        AuthenticationPolicy policy = (AuthenticationPolicy)super.readResource(mediaType, src);
        this.log.debug("About to unmarshall the following JSON representation: {}", (Object)src.toString());
        JsonString stringProperty = src.getJsonString("status");
        if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)stringProperty)) {
            policy.setStatus(AuthenticationPolicyStatus.valueOf(stringProperty.getString().toUpperCase()));
        }
        if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(stringProperty = src.getJsonString("name")))) {
            policy.setName(stringProperty.getString());
        }
        if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(stringProperty = src.getJsonString("desc")))) {
            policy.setDescription(stringProperty.getString());
        }
        if ((rulesJson = src.getJsonArray("rules")) != null) {
            this.readRules(rulesJson, policy);
        }
        return policy;
    }

    protected void readRules(@Nonnull JsonArray rulesJson, @Nonnull AuthenticationPolicy policy) {
        for (JsonValue value : rulesJson) {
            if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isObject((JsonValue)value)) {
                this.log.debug("skipping unsupported value type");
                continue;
            }
            JsonObject ruleJson = (JsonObject)value;
            JsonString ruleType = ruleJson.getJsonString("type");
            if (ruleType == null) {
                throw new EntityReaderException("Rule object does not contain a type property");
            }
            AbstractAuthenticationPolicyRuleReader ruleCodec = this.ruleCodecs.get(StringSupport.trimOrEmpty((String)ruleType.getString()).toLowerCase());
            if (ruleCodec == null) {
                throw new EntityReaderException("Rule object type property is null or empty");
            }
            policy.addRule((AbstractAuthenticationPolicyRule)ruleCodec.read(ruleJson));
        }
    }

    @Nonnull
    protected AuthenticationPolicy createResource(@Nonnull MediaType mediaType) {
        return new AuthenticationPolicy();
    }

    @Nonnull
    public Class<AuthenticationPolicy> getResourceType() {
        return AuthenticationPolicy.class;
    }

    @Unmodifiable
    @Nonnull
    @NonnullElements
    public Collection<AbstractAuthenticationPolicyRuleReader> getAuthenticationPolicyRuleCodecs() {
        return Collections.unmodifiableCollection(this.ruleCodecs.values());
    }

    public void setAuthenticationPolicyRuleCodecs(Collection<AbstractAuthenticationPolicyRuleReader> codecs) {
        if (codecs == null) {
            return;
        }
        this.ruleCodecs = new HashMap<String, AbstractAuthenticationPolicyRuleReader>();
        for (AbstractAuthenticationPolicyRuleReader codec : codecs) {
            if (codec == null) continue;
            this.ruleCodecs.put(codec.getRuleType().toLowerCase(), codec);
        }
    }

    public boolean isReadable(@Nonnull MediaType mediaType) {
        return JsonpSupport.isMediaTypeSame(SupportedMediaType.AUTHN_POLICY_MT, mediaType);
    }
}

