/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.policy.io.jsonp;

import com.covisint.core.http.service.core.AbstractRealmScopedResource;
import com.covisint.core.http.service.core.io.EntityWriterException;
import com.covisint.core.http.service.core.io.jsonp.AbstractRealmScopedResourceWriter;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NonnullElements;
import com.covisint.core.support.constraint.Unmodifiable;
import com.covisint.platform.authn.core.policy.AbstractAuthenticationPolicyRule;
import com.covisint.platform.authn.core.policy.AuthenticationPolicy;
import com.covisint.platform.authn.core.policy.io.jsonp.AbstractAuthenticationPolicyRuleWriter;
import com.covisint.platform.authn.core.util.JsonpSupport;
import com.covisint.platform.authn.core.util.SupportedMediaType;
import com.google.common.net.MediaType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;

public class AuthenticationPolicyWriter
extends AbstractRealmScopedResourceWriter<AuthenticationPolicy> {
    private Map<String, AbstractAuthenticationPolicyRuleWriter> ruleCodecs = Collections.EMPTY_MAP;

    @Nonnull
    protected JsonObjectBuilder writeResource(@Nonnull MediaType mediaType, @Nonnull AuthenticationPolicy policy) {
        JsonObjectBuilder builder = super.writeResource(mediaType, (AbstractRealmScopedResource)policy);
        if (policy.getStatus() != null) {
            builder.add("status", policy.getStatus().toString());
        }
        com.covisint.core.http.service.core.io.jsonp.JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)builder, (String)"name", (String)policy.getName());
        com.covisint.core.http.service.core.io.jsonp.JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)builder, (String)"desc", (String)policy.getDescription());
        if (policy.getRules().size() > 0) {
            JsonArrayBuilder rulesJson = Json.createArrayBuilder();
            for (AbstractAuthenticationPolicyRule rule : policy.getRules().values()) {
                AbstractAuthenticationPolicyRuleWriter ruleCodec = this.ruleCodecs.get(rule.getType().toLowerCase());
                if (ruleCodec == null) {
                    throw new EntityWriterException("Rule of type " + rule.getType().toLowerCase() + " does not have a registered codec");
                }
                rulesJson.add(ruleCodec.write(rule));
            }
            builder.add("rules", rulesJson);
        }
        return builder;
    }

    @Nonnull
    public Class<AuthenticationPolicy> getResourceType() {
        return AuthenticationPolicy.class;
    }

    @Unmodifiable
    @Nonnull
    @NonnullElements
    public Collection<AbstractAuthenticationPolicyRuleWriter> getAuthenticationPolicyRuleCodecs() {
        return Collections.unmodifiableCollection(this.ruleCodecs.values());
    }

    public void setAuthenticationPolicyRuleCodecs(Collection<AbstractAuthenticationPolicyRuleWriter> codecs) {
        if (codecs == null) {
            return;
        }
        this.ruleCodecs = new HashMap<String, AbstractAuthenticationPolicyRuleWriter>();
        for (AbstractAuthenticationPolicyRuleWriter codec : codecs) {
            if (codec == null) continue;
            this.ruleCodecs.put(codec.getRuleType().toLowerCase(), codec);
        }
    }

    public boolean isWritable(@Nonnull Class klass, @Nonnull MediaType mediaType) {
        return JsonpSupport.isMediaTypeSame(SupportedMediaType.AUTHN_POLICY_MT, mediaType);
    }
}

