/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.securityquestion.io.jsonp;

import com.covisint.core.http.service.core.ResourceReference;
import com.covisint.core.http.service.core.io.jsonp.AbstractRealmScopedResourceReader;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.platform.authn.core.securityquestion.SecurityQuestion;
import com.covisint.platform.authn.core.util.JsonpSupport;
import com.covisint.platform.authn.core.util.SupportedMediaType;
import com.google.common.net.MediaType;
import java.util.HashMap;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;

public class SecurityQuestionReader
extends AbstractRealmScopedResourceReader<SecurityQuestion> {
    @Nullable
    private Map<String, String> unmarshallMultiLingualStringMap(@Nonnull JsonArray mapJsonArray) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (JsonObject multiLingualString : mapJsonArray) {
            if (com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)multiLingualString.getJsonString("lang")) || com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)multiLingualString.getJsonString("text"))) {
                return null;
            }
            map.put(multiLingualString.getString("lang"), multiLingualString.getString("text"));
        }
        return map;
    }

    @Nonnull
    protected SecurityQuestion createResource(@Nonnull MediaType mediaType) {
        return new SecurityQuestion();
    }

    public boolean isReadable(@Nonnull MediaType mediaType) {
        return JsonpSupport.isMediaTypeSame(SupportedMediaType.SECURITY_QUESTION_MT, mediaType);
    }

    @Nonnull
    public Class getResourceType() {
        return SecurityQuestion.class;
    }

    @Nonnull
    public final SecurityQuestion readResource(@Nonnull MediaType mediaType, @Nonnull JsonObject json) {
        JsonObject ownerJson;
        ResourceReference owner;
        Map<String, String> questionTextMap;
        SecurityQuestion securityQuestion = (SecurityQuestion)super.readResource(mediaType, json);
        JsonArray questionJson = json.getJsonArray("question");
        if (questionJson != null && (questionTextMap = this.unmarshallMultiLingualStringMap(questionJson)) != null) {
            securityQuestion.setQuestion(questionTextMap);
        }
        if ((owner = SecurityQuestionReader.readResourceReference((JsonObject)(ownerJson = json.getJsonObject("owner")))) != null) {
            securityQuestion.setOwner(owner);
        }
        return securityQuestion;
    }
}

