/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.userpin.io.jsonp;

import com.covisint.core.http.service.core.io.EntityWriter;
import com.covisint.core.http.service.core.io.EntityWriterException;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.platform.authn.core.util.JsonpSupport;
import com.covisint.platform.authn.core.util.SupportedMediaType;
import com.google.common.base.Charsets;
import com.google.common.net.MediaType;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinValidationResponseWriter
implements EntityWriter<Object> {
    private final Logger log = LoggerFactory.getLogger(PinValidationResponseWriter.class);

    protected JsonObject writeSingleEntity(Object inputObject) {
        Boolean entity = (Boolean)inputObject;
        JsonObjectBuilder policyJson = Json.createObjectBuilder();
        policyJson.add("isCorrect", entity.booleanValue());
        return policyJson.build();
    }

    @Nonnull
    public Class getResourceType() {
        return Boolean.class;
    }

    public boolean isWritable(@Nonnull Class<?> clazz, @Nonnull MediaType mediaType) {
        return JsonpSupport.isMediaTypeSame(SupportedMediaType.PIN_VALIDATION_MT, mediaType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MediaType write(@Nonnull MediaType mediaType, @Nonnull Object source, @Nonnull OutputStream output) {
        JsonWriterFactory jsonFactory = Json.createWriterFactory(new HashMap());
        try (JsonWriter writer = jsonFactory.createWriter(output, Charsets.UTF_8);){
            this.log.debug("Writing JSON to output stream");
            if (source instanceof Boolean) {
                writer.write((JsonStructure)this.writeSingleEntity(source));
            } else {
                if (!(source instanceof Collection)) throw new EntityWriterException("Unsupport object type can not be marshalled");
                JsonArrayBuilder policiesJson = Json.createArrayBuilder();
                for (Boolean entity : (Collection)source) {
                    if (!this.getResourceType().isAssignableFrom(source.getClass())) {
                        throw new EntityWriterException("The server is unable to produce content of type");
                    }
                    policiesJson.add((JsonValue)this.writeSingleEntity(entity));
                }
                writer.write((JsonStructure)this.writeSingleEntity(policiesJson.build()));
            }
            MediaType mediaType2 = mediaType;
            return mediaType2;
        }
        catch (IllegalStateException | JsonException e) {
            this.log.debug("Unable to write JSON to output stream", e);
            throw new EntityWriterException("Unable to write JSON");
        }
    }
}

