/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.oauth.core.domain;

import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.platform.oauth.core.domain.AbstractGrantType;
import com.covisint.platform.oauth.core.util.CertificateUtils;
import com.google.common.base.Objects;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="Certificate_Grant")
public class CertificateGrantType
extends AbstractGrantType {
    private static final long serialVersionUID = 3833150824989553260L;
    @Transient
    private transient Certificate certificate;
    @Column(name="public_key", nullable=false, columnDefinition="varchar(2048)")
    private String publicKey;

    @Nullable
    public Certificate getCertificate() {
        return this.certificate;
    }

    public CertificateGrantType setCertificate(Certificate cert) {
        this.certificate = cert;
        this.setPubKey(CertificateUtils.serializePublicKey(this.certificate.getPublicKey()));
        return this;
    }

    @Nullable
    public String getPubKey() {
        return this.publicKey;
    }

    public CertificateGrantType setPubKey(String key) {
        this.publicKey = key;
        return this;
    }

    public CertificateGrantType setCertificate(String string) throws GeneralSecurityException {
        this.certificate = CertificateUtils.parseCertificate(string);
        return this;
    }

    @Nonnull
    @NotEmpty
    public final String toString() {
        return this.populateToStringHelper(Objects.toStringHelper((Object)((Object)this))).add("publicKey", (Object)"*******").toString();
    }

    public final int hashCode() {
        return this.getResourceIdentityHashCode();
    }

    public final boolean equals(Object obj) {
        return this.isResourceIdentityEqual(CertificateGrantType.class, obj);
    }
}

