/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.client.account.securityquestion;

import com.covisint.core.http.service.client.BaseResourceClient;
import com.covisint.core.http.service.client.CachingFutureCallback;
import com.covisint.core.http.service.client.ClientException;
import com.covisint.core.http.service.core.Page;
import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.http.service.core.SortCriteria;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.platform.authn.client.account.securityquestion.SecurityQuestionAccountClient;
import com.covisint.platform.authn.core.account.securityquestion.SecurityQuestionAccount;
import com.covisint.platform.authn.core.util.SupportedMediaType;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.VariableExpansionException;
import com.google.common.collect.Multimap;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityQuestionAccountClientImpl
extends BaseResourceClient<SecurityQuestionAccount>
implements SecurityQuestionAccountClient {
    private static final MediaType SECURITY_QUESTION_ACCOUNT_MT = MediaType.parse((String)SupportedMediaType.SECURITY_QUESTION_ACCOUNT_MT.value());
    private final Logger log = LoggerFactory.getLogger(SecurityQuestionAccountClientImpl.class);
    private UriTemplate updateSecurityQuestionAccountUriTemplate;
    private UriTemplate getSecurityQuestionAccountUriTemplate;

    void setUpdateSecurityQuestionAccountUriTemplate(@Nonnull UriTemplate template) {
        this.updateSecurityQuestionAccountUriTemplate = template;
    }

    void setGetSecurityQuestionAccountUriTemplate(@Nonnull UriTemplate template) {
        this.getSecurityQuestionAccountUriTemplate = template;
    }

    @Override
    @Nonnull
    public CheckedFuture<SecurityQuestionAccount, ServiceException> persist(@Nonnull @NotEmpty String personId, @Nonnull SecurityQuestionAccount securityQuestionAccount, @Nonnull HttpContext context) {
        try {
            String url = this.updateSecurityQuestionAccountUriTemplate.set("personId", (Object)personId).expand();
            return this.executeWithBody((HttpEntityEnclosingRequestBase)new HttpPut(url), SECURITY_QUESTION_ACCOUNT_MT, securityQuestionAccount, context);
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    @Nonnull
    public CheckedFuture<SecurityQuestionAccount, ServiceException> get(@Nonnull @NotEmpty String personId, @Nonnull HttpContext httpContext) {
        String cacheKey = String.format("get-by-id-%s", personId);
        SecurityQuestionAccount cachedResult = (SecurityQuestionAccount)this.getLocalCache().getIfPresent((Object)cacheKey);
        if (cachedResult != null) {
            this.log.debug("Found active cache for key {}; using it.", (Object)cacheKey);
            return Futures.immediateCheckedFuture((Object)cachedResult);
        }
        try {
            String url = this.getSecurityQuestionAccountUriTemplate.set("personId", (Object)personId).expand();
            CheckedFuture futureResult = this.execute((HttpUriRequest)new HttpGet(url), SECURITY_QUESTION_ACCOUNT_MT, httpContext);
            Futures.addCallback((ListenableFuture)futureResult, (FutureCallback)new CachingFutureCallback(this.getLocalCache(), cacheKey));
            return futureResult;
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    @Nonnull
    public CheckedFuture<SecurityQuestionAccount, ServiceException> persist(@Nonnull SecurityQuestionAccount resource, @Nonnull HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public CheckedFuture<SecurityQuestionAccount, ServiceException> get(@Nonnull SecurityQuestionAccount resource, @Nonnull HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public CheckedFuture<SecurityQuestionAccount, ServiceException> add(@Nonnull SecurityQuestionAccount resource, @Nonnull HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public CheckedFuture<SecurityQuestionAccount, ServiceException> delete(@Nonnull @NotEmpty String id, @Nonnull HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public CheckedFuture<List<SecurityQuestionAccount>, ServiceException> search(@Nonnull Multimap<String, String> searchCriteria, @Nullable SortCriteria sortCriteria, @Nonnull Page page, @Nonnull HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<List<SecurityQuestionAccount>, ServiceException> search(Multimap<String, String> searchCriteria, SortCriteria sortCriteria, @Nonnull Page page, HttpContext httpContext, MediaType mediaType, String searchResourcesEndPoint) {
        throw new UnsupportedOperationException();
    }
}

