/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.client.password;

import com.covisint.core.http.service.client.BaseResourceClient;
import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.support.constraint.Constraints;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.platform.authn.client.password.PasswordClient;
import com.covisint.platform.authn.core.password.Password;
import com.covisint.platform.authn.core.password.PasswordBatchUpdateRequest;
import com.covisint.platform.authn.core.password.UpdateMode;
import com.covisint.platform.authn.core.password.authenticate.PasswordAuthenticationRequest;
import com.covisint.platform.authn.core.password.authenticate.PasswordAuthenticationResponse;
import com.covisint.platform.authn.core.util.SupportedMediaType;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.VariableExpansionException;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;

public final class PasswordClientImpl
extends BaseResourceClient<Password>
implements PasswordClient {
    private UriTemplate updatePasswordTemplate;
    private UriTemplate expirePasswordTemplate;
    private UriTemplate lockPasswordTemplate;
    private UriTemplate unlockPasswordTemplate;
    private UriTemplate getByIdEndpointTemplate;
    private String batchUpdateAuthnPolicyIdsEndpoint;
    private String batchUpdatePasswordPolicyIdsEndpoint;
    private String authenticateEndpoint;

    PasswordClientImpl() {
    }

    private CheckedFuture<Password, ServiceException> lockPassword(@Nonnull @NotEmpty String subject, long lockoutDuration, @Nonnull HttpContext httpContext) {
        Constraints.isNotNull((Object)this.lockPasswordTemplate, (String)"lock password URI template was null.");
        try {
            HashMap<String, String> uriVars = new HashMap<String, String>();
            uriVars.put("subject", subject);
            MediaType mediaType = MediaType.parse((String)SupportedMediaType.PASSWORD_MT.value()).withoutParameters();
            return this.execute((HttpUriRequest)new HttpGet(this.lockPasswordTemplate.expand(uriVars)), mediaType, httpContext);
        }
        catch (VariableExpansionException e) {
            throw new RuntimeException(e);
        }
    }

    PasswordClientImpl setUpdatePasswordTemplate(@Nonnull UriTemplate template) {
        this.updatePasswordTemplate = template;
        return this;
    }

    PasswordClientImpl setExpirePasswordTemplate(@Nonnull UriTemplate template) {
        this.expirePasswordTemplate = template;
        return this;
    }

    PasswordClientImpl setLockPasswordTemplate(@Nonnull UriTemplate template) {
        this.lockPasswordTemplate = template;
        return this;
    }

    PasswordClientImpl setUnlockPasswordTemplate(@Nonnull UriTemplate template) {
        this.unlockPasswordTemplate = template;
        return this;
    }

    PasswordClientImpl setAuthenticationEndpoint(@Nonnull @NotEmpty String endpoint) {
        this.authenticateEndpoint = endpoint;
        return this;
    }

    PasswordClientImpl setBatchUpdateAuthnPolicyIdsTemplate(@Nonnull @NotEmpty String endpoint) {
        this.batchUpdateAuthnPolicyIdsEndpoint = endpoint;
        return this;
    }

    PasswordClientImpl setBatchUpdatePasswordPolicyIdsTemplate(@Nonnull @NotEmpty String endpoint) {
        this.batchUpdatePasswordPolicyIdsEndpoint = endpoint;
        return this;
    }

    PasswordClientImpl setGetByIdEndpointTemplate(@Nonnull UriTemplate endpoint) {
        this.getByIdEndpointTemplate = endpoint;
        return this;
    }

    @Override
    public CheckedFuture<Password, ServiceException> getPassword(@Nonnull @NotEmpty String userId, @Nonnull HttpContext httpContext) {
        try {
            MediaType mediaType = MediaType.parse((String)SupportedMediaType.PASSWORD_MT.value()).withoutParameters();
            return this.execute((HttpUriRequest)new HttpGet(this.getByIdEndpointTemplate.set("id", (Object)userId).expand()), mediaType, httpContext);
        }
        catch (VariableExpansionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CheckedFuture<Password, ServiceException> updatePassword(@Nonnull Password newPassword, @Nonnull UpdateMode updateMode, @Nonnull HttpContext httpContext) {
        Constraints.isNotNull((Object)this.updatePasswordTemplate, (String)"update password URI template was null.");
        try {
            MediaType mediaType = MediaType.parse((String)SupportedMediaType.PASSWORD_MT.value()).withoutParameters();
            HashMap<String, String> uriVars = new HashMap<String, String>();
            uriVars.put("id", newPassword.getId());
            uriVars.put("mode", updateMode.toString());
            return this.executeWithBody((HttpEntityEnclosingRequestBase)new HttpPut(this.updatePasswordTemplate.expand(uriVars)), mediaType, newPassword, httpContext);
        }
        catch (VariableExpansionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CheckedFuture<Password, ServiceException> expirePassword(@Nonnull @NotEmpty String subject, @Nonnull HttpContext httpContext) {
        Constraints.isNotNull((Object)this.expirePasswordTemplate, (String)"expire password URI template was null.");
        try {
            HashMap<String, String> uriVars = new HashMap<String, String>();
            uriVars.put("subject", subject);
            MediaType mediaType = MediaType.parse((String)SupportedMediaType.PASSWORD_MT.value()).withoutParameters();
            return this.execute((HttpUriRequest)new HttpGet(this.expirePasswordTemplate.expand(uriVars)), mediaType, httpContext);
        }
        catch (VariableExpansionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CheckedFuture<Password, ServiceException> lockPassword(@Nonnull @NotEmpty String subject, @Nonnull HttpContext httpContext) {
        return this.lockPassword(subject, 0L, httpContext);
    }

    @Override
    public CheckedFuture<Password, ServiceException> lockPassword(@Nonnull @NotEmpty String subject, long lockDuration, @Nonnull TimeUnit durationUnit, @Nonnull HttpContext httpContext) {
        return this.lockPassword(subject, TimeUnit.MILLISECONDS.convert(lockDuration, durationUnit), httpContext);
    }

    @Override
    public CheckedFuture<Password, ServiceException> unlockPassword(@Nonnull @NotEmpty String subject, @Nonnull HttpContext httpContext) {
        Constraints.isNotNull((Object)this.unlockPasswordTemplate, (String)"unlock password URI template was null.");
        try {
            HashMap<String, String> uriVars = new HashMap<String, String>();
            uriVars.put("subject", subject);
            MediaType mediaType = MediaType.parse((String)SupportedMediaType.PASSWORD_MT.value()).withoutParameters();
            return this.execute((HttpUriRequest)new HttpGet(this.unlockPasswordTemplate.expand(uriVars)), mediaType, httpContext);
        }
        catch (VariableExpansionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CheckedFuture<PasswordAuthenticationResponse, ServiceException> authentication(@Nonnull PasswordAuthenticationRequest request, @Nonnull HttpContext httpContext) {
        MediaType contentMediaType = MediaType.parse((String)SupportedMediaType.PASSWORD_AUTHN_REQUEST_MT.value()).withoutParameters();
        MediaType acceptMediaType = MediaType.parse((String)SupportedMediaType.PASSWORD_AUTHN_REPONSE_MT.value()).withoutParameters();
        return this.executeWithBody((HttpEntityEnclosingRequestBase)new HttpPost(this.authenticateEndpoint), contentMediaType, acceptMediaType, request, httpContext);
    }

    @Override
    public CheckedFuture<Void, ServiceException> batchUpdateAuthnPolicyIds(@Nonnull PasswordBatchUpdateRequest request, @Nonnull HttpContext httpContext) {
        MediaType mediaType = MediaType.parse((String)SupportedMediaType.PASSWORD_BATCH_REQUEST_MT.value()).withoutParameters();
        return this.executeWithBody((HttpEntityEnclosingRequestBase)new HttpPut(this.batchUpdateAuthnPolicyIdsEndpoint), mediaType, request, httpContext);
    }

    @Override
    public CheckedFuture<Void, ServiceException> batchUpdatePasswordPolicyIds(@Nonnull PasswordBatchUpdateRequest request, @Nonnull HttpContext httpContext) {
        MediaType mediaType = MediaType.parse((String)SupportedMediaType.PASSWORD_BATCH_REQUEST_MT.value()).withoutParameters();
        return this.executeWithBody((HttpEntityEnclosingRequestBase)new HttpPut(this.batchUpdatePasswordPolicyIdsEndpoint), mediaType, request, httpContext);
    }

    public CheckedFuture<Password, ServiceException> add(Password resource, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<Password, ServiceException> persist(Password resource, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<Password, ServiceException> delete(String id, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }
}

