/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.client.password.policy;

import com.covisint.core.http.service.client.BaseResourceClient;
import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.support.constraint.Constraints;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.platform.authn.client.password.policy.PasswordPolicyClient;
import com.covisint.platform.authn.core.password.policy.Operation;
import com.covisint.platform.authn.core.password.policy.PasswordPolicy;
import com.covisint.platform.authn.core.password.validation.PasswordValidationResponse;
import com.covisint.platform.authn.core.util.SupportedMediaType;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.VariableExpansionException;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.CheckedFuture;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.EnumSet;
import java.util.HashMap;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;

public final class PasswordPolicyClientImpl
extends BaseResourceClient<PasswordPolicy>
implements PasswordPolicyClient {
    private UriTemplate validateTemplate;

    PasswordPolicyClientImpl() {
    }

    public void setValidateTemplate(@Nonnull UriTemplate newValidateTemplate) {
        this.validateTemplate = newValidateTemplate;
    }

    @Override
    @Nonnull
    public CheckedFuture<PasswordValidationResponse, ServiceException> validatePassword(@Nonnull @NotEmpty String passwordPolicyId, @Nonnull @NotEmpty String password, @Nullable String userId, @Nonnull @NotEmpty EnumSet<Operation> operations, @Nonnull HttpContext httpContext) {
        Constraints.isNotNull((Object)this.validateTemplate, (String)"Validation URI template was null.");
        try {
            HashMap<String, Object> uriVars = new HashMap<String, Object>();
            uriVars.put("policyId", passwordPolicyId);
            uriVars.put("userId", userId);
            uriVars.put("password", password);
            uriVars.put("scope", operations);
            StringBuilder url = new StringBuilder(this.validateTemplate.expand(uriVars));
            url.append("&password=").append(URLEncoder.encode(password, "UTF-8"));
            MediaType resourceMediaType = MediaType.parse((String)SupportedMediaType.PASSWORD_VALIDATION_RESPONSE_MT.value());
            return this.execute((HttpUriRequest)new HttpGet(url.toString()), resourceMediaType.withoutParameters(), httpContext);
        }
        catch (VariableExpansionException | UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public CheckedFuture<PasswordPolicy, ServiceException> persist(PasswordPolicy resource, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }
}

