/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.client.sdk;

import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.httpclient.HttpClientBuilder;
import com.covisint.platform.authn.client.account.securityquestion.SecurityQuestionAccountClientFactory;
import com.covisint.platform.authn.client.account.securityquestion.SecurityQuestionAccountClientImpl;
import com.covisint.platform.authn.core.account.securityquestion.SecurityQuestionAccount;
import com.covisint.platform.oauth.client.token.sdk.AuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.DefaultAuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.TokenSupplier;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.CheckedFuture;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class SecurityQuestionAccountSDK
extends SecurityQuestionAccountClientFactory {
    private AuthConfigurationProvider authConfigProvider;

    public SecurityQuestionAccountSDK(@Nonnull @NotEmpty String serviceUrl) {
        super(serviceUrl);
    }

    @Nonnull
    protected AuthConfigurationProvider getAuthConfigProvider() {
        if (this.authConfigProvider == null) {
            this.authConfigProvider = new DefaultAuthConfigurationProvider();
        }
        return this.authConfigProvider;
    }

    protected HttpClientBuilder populateHttpClientBuilder(@Nonnull HttpClientBuilder builder) {
        TokenSupplier tokenSupplier = new TokenSupplier(this.getAuthConfigProvider());
        builder.addAuthorizationTokenInterceptor((Supplier)tokenSupplier);
        return builder;
    }

    public SecurityQuestionAccountSDK setAuthConfigProvider(@Nonnull AuthConfigurationProvider provider) {
        this.authConfigProvider = provider;
        return this;
    }

    public SecurityQuestionAccountClientImpl create() {
        throw new UnsupportedOperationException("Please use #newClient to create new client instances.");
    }

    @Nonnull
    public SecurityQuestionAccountClient newClient() {
        return new ClientImpl((SecurityQuestionAccountClientImpl)super.create());
    }

    private static final class ClientImpl
    implements SecurityQuestionAccountClient {
        private final SecurityQuestionAccountClientImpl delegate;

        private ClientImpl(@Nonnull SecurityQuestionAccountClientImpl newDelegate) {
            this.delegate = newDelegate;
        }

        @Override
        @Nonnull
        public CheckedFuture<SecurityQuestionAccount, ServiceException> get(@Nonnull @NotEmpty String personId) {
            return this.delegate.get(personId, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<SecurityQuestionAccount, ServiceException> update(@Nonnull @NotEmpty String personId, @Nonnull SecurityQuestionAccount account) {
            return this.delegate.persist(personId, account, (HttpContext)new BasicHttpContext());
        }
    }

    public static interface SecurityQuestionAccountClient {
        @Nonnull
        public CheckedFuture<SecurityQuestionAccount, ServiceException> get(@Nonnull @NotEmpty String var1);

        @Nonnull
        public CheckedFuture<SecurityQuestionAccount, ServiceException> update(@Nonnull @NotEmpty String var1, @Nonnull SecurityQuestionAccount var2);
    }
}

