/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.client.userpin;

import com.covisint.core.http.service.client.BaseResourceClient;
import com.covisint.core.http.service.core.Page;
import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.http.service.core.SortCriteria;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.platform.authn.client.userpin.PinClient;
import com.covisint.platform.authn.core.userpin.Pin;
import com.covisint.platform.authn.core.util.SupportedMediaType;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.VariableExpansionException;
import com.google.common.collect.Multimap;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.List;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinClientImpl
extends BaseResourceClient<Pin>
implements PinClient {
    private final Logger log = LoggerFactory.getLogger(PinClientImpl.class);
    private UriTemplate validateEndpointTemplate;
    private UriTemplate existingEndpointTemplate;

    @Override
    public CheckedFuture<Boolean, ServiceException> validatePIN(@Nonnull @NotEmpty String id, @Nonnull @NotEmpty String pin, @Nonnull @NotEmpty String requestor, @Nonnull HttpContext httpContext) {
        this.log.debug("validatePIN | id: {}, PIN:{}, requester:{}.", new Object[]{id, pin, requestor});
        Pin pinObject = new Pin();
        pinObject.setId(id);
        pinObject.setPin(pin);
        pinObject.setCreator(requestor);
        MediaType resourceMediaType = MediaType.parse((String)SupportedMediaType.PIN_MT.value());
        try {
            return this.executeWithBody((HttpEntityEnclosingRequestBase)new HttpPost(this.validateEndpointTemplate.expand()), resourceMediaType.withoutParameters(), pinObject, httpContext);
        }
        catch (VariableExpansionException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public CheckedFuture<Boolean, ServiceException> isExisting(@Nonnull @NotEmpty String id, @Nonnull HttpContext httpContext) {
        this.log.debug("isExisting | id: {}.", (Object)id);
        MediaType resourceMediaType = MediaType.parse((String)SupportedMediaType.PIN_MT.value());
        try {
            return this.execute((HttpUriRequest)new HttpGet(this.existingEndpointTemplate.set("id", (Object)id).expand()), resourceMediaType.withoutParameters(), httpContext);
        }
        catch (VariableExpansionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public UriTemplate getValidateEndpointTemplate() {
        return this.validateEndpointTemplate;
    }

    public void setValidateEndpointTemplate(UriTemplate newValidateEndpointTemplate) {
        this.validateEndpointTemplate = newValidateEndpointTemplate;
    }

    public UriTemplate getExistingEndpointTemplate() {
        return this.existingEndpointTemplate;
    }

    public void setExistingEndpointTemplate(UriTemplate newExistingEndpointTemplate) {
        this.existingEndpointTemplate = newExistingEndpointTemplate;
    }

    public CheckedFuture<List<Pin>, ServiceException> search(Multimap<String, String> searchCriteria, SortCriteria sortCriteria, Page page, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<Pin, ServiceException> add(Pin resource, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }
}

