/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.core.http.service.core;

import com.covisint.core.http.service.core.ResourceReference;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.google.common.base.Objects;
import java.util.HashMap;
import java.util.Map;

public class NamedResourceReference
extends ResourceReference {
    private Map<String, String> name;
    private Map<String, String> description;

    public NamedResourceReference(@Nonnull ResourceReference ref, @Nonnull Map<String, String> newName, @Nonnull Map<String, String> newDescription) {
        this(ref.getId(), ref.getType(), ref.getRealm(), newName, newDescription);
    }

    public NamedResourceReference(@Nonnull @NotEmpty String id, @Nonnull @NotEmpty String type, @Nonnull Map<String, String> newName, @Nonnull Map<String, String> newDescription) {
        this(id, type, null, newName, newDescription);
    }

    public NamedResourceReference(@Nonnull @NotEmpty String id, @Nonnull @NotEmpty String type, @Nonnull @NotEmpty String realm, @Nonnull Map<String, String> newName, @Nonnull Map<String, String> newDescription) {
        super(id, type, realm);
        this.name = this.copyIfNotNull(newName);
        this.description = this.copyIfNotNull(newDescription);
    }

    private Map<String, String> copyIfNotNull(Map<String, String> map) {
        HashMap<String, String> copiedmap = null;
        if (map != null && map.size() > 0) {
            copiedmap = new HashMap<String, String>();
            copiedmap.putAll(map);
        }
        return copiedmap;
    }

    @Nonnull
    public Map<String, String> getName() {
        return this.copyIfNotNull(this.name);
    }

    @Nonnull
    public Map<String, String> getDescription() {
        return this.copyIfNotNull(this.description);
    }

    public void setName(@Nonnull Map<String, String> newName) {
        this.name = this.copyIfNotNull(newName);
    }

    public void setDescription(@Nonnull Map<String, String> newDescription) {
        this.description = this.copyIfNotNull(newDescription);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NamedResourceReference)) {
            return false;
        }
        NamedResourceReference that = (NamedResourceReference)obj;
        return super.equals(that) && Objects.equal(this.name, that.name) && Objects.equal(this.description, that.description);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.description, super.hashCode()});
    }

    @Override
    @Nonnull
    @NotEmpty
    public String toString() {
        return Objects.toStringHelper((Object)this).addValue((Object)super.toString()).add("name", this.name).add("description", this.description).toString();
    }
}

