/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.core.http.service.core.io.jsonp;

import com.covisint.core.http.service.core.HttpServiceError;
import com.covisint.core.http.service.core.io.EntityParsingException;
import com.covisint.core.http.service.core.io.EntityReader;
import com.covisint.core.http.service.core.io.EntityReaderException;
import com.covisint.core.http.service.core.io.jsonp.JsonpSupport;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NonnullElements;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.MediaType;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonParsingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServiceErrorReader<T extends HttpServiceError>
implements EntityReader {
    public static final Set<MediaType> SUPPORTED_MEDIA_TYPES = ImmutableSet.of((Object)JsonpSupport.HTTP_SERVICE_ERROR_V1_MEDIA_TYPE);
    private final Logger log = LoggerFactory.getLogger(HttpServiceErrorReader.class);

    @Nonnull
    public Class<HttpServiceError> getResourceType() {
        return HttpServiceError.class;
    }

    @Override
    public boolean isReadable(@Nonnull MediaType mediaType) {
        return SUPPORTED_MEDIA_TYPES.contains(mediaType.withoutParameters());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object read(@Nonnull MediaType mediaType, @Nonnull InputStream input) {
        this.log.debug("Preparing to parse JSON data from inputstream");
        try (JsonReader jsonReader = Json.createReader((InputStream)input);){
            JsonStructure json = jsonReader.read();
            this.log.debug("Parsed a JSON structure of type {}", (Object)json.getValueType().toString());
            if (JsonpSupport.isArray((JsonValue)json)) {
                List<T> list = this.readResourceArray(mediaType, (JsonArray)json);
                return list;
            }
            if (JsonpSupport.isObject((JsonValue)json)) {
                T t = this.readResource(mediaType, (JsonObject)json);
                return t;
            }
            this.log.debug("Root-level JSON structure of type {} is not supported by this reader", (Object)json.getValueType().toString());
            throw new EntityReaderException("Root-level JSON structure of " + json.getValueType().toString() + " is not supported.");
        }
        catch (JsonParsingException e) {
            this.log.debug("Invalid JSON, unable to parse", (Throwable)e);
            throw new EntityParsingException(e.getLocation().getLineNumber(), e.getLocation().getColumnNumber(), (Throwable)e);
        }
        catch (IllegalStateException | JsonException e) {
            this.log.debug("Unable to parse JSON", e);
            throw new EntityReaderException("Unable to parse JSON");
        }
    }

    @Nonnull
    @NonnullElements
    protected List<T> readResourceArray(@Nonnull MediaType mediaType, @Nonnull JsonArray jsonArray) {
        ArrayList<T> resources = new ArrayList<T>();
        for (JsonValue jsonElement : jsonArray) {
            if (JsonpSupport.isObject(jsonElement)) {
                resources.add(this.readResource(mediaType, (JsonObject)jsonElement));
                continue;
            }
            if (JsonpSupport.isNull(jsonElement)) {
                this.log.debug("JSON array contained a null element, ignoring it");
                continue;
            }
            this.log.debug("{} JSON structure is not supported within the root-level array", (Object)jsonElement.getValueType().toString());
            throw new EntityReaderException(jsonElement.getValueType().toString() + " JSON structure of is not supported in root-level array.");
        }
        return resources;
    }

    protected T readResource(@Nonnull MediaType mediaType, @Nonnull JsonObject json) {
        this.log.debug("Created a resource of type {} into which the JSON data will be read", (Object)HttpServiceError.class.getName());
        int httpStatus = 0;
        JsonNumber numberValue = json.getJsonNumber("status");
        if (numberValue != null) {
            httpStatus = numberValue.intValue();
        }
        String apiStatusCode = null;
        JsonString stringValue = json.getJsonString("apiStatusCode");
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull(stringValue)) {
            apiStatusCode = stringValue.getString();
        }
        String apiMessage = null;
        stringValue = json.getJsonString("apiMessage");
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull(stringValue)) {
            apiMessage = stringValue.getString();
        }
        HttpServiceError resource = new HttpServiceError(httpStatus, apiStatusCode, apiMessage);
        return (T)resource;
    }
}

