/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.oauth.core.granttype.certificate.io.json;

import com.covisint.core.http.service.core.io.jsonp.AbstractRealmScopedResourceReader;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.platform.oauth.core.JsonpSupport;
import com.covisint.platform.oauth.core.SupportedMediaType;
import com.covisint.platform.oauth.core.domain.AbstractGrantType;
import com.covisint.platform.oauth.core.domain.CertificateGrantType;
import com.google.common.net.MediaType;
import javax.json.JsonObject;
import javax.json.JsonString;

public class CertificateGrantTypeReader
extends AbstractRealmScopedResourceReader<CertificateGrantType> {
    private void readPublicKey(@Nonnull JsonObject src, @Nonnull CertificateGrantType grantType) {
        JsonString stringValue = src.getJsonString("publicKey");
        if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)stringValue)) {
            grantType.setPubKey(stringValue.getString());
        }
    }

    private void readAppId(@Nonnull JsonObject src, @Nonnull CertificateGrantType grantType) {
        JsonString stringValue = src.getJsonString("applicationId");
        if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)stringValue)) {
            grantType.setAppId(stringValue.getString());
        }
    }

    @Nullable
    protected CertificateGrantType readResource(@Nonnull MediaType mediaType, @Nonnull JsonObject json) {
        CertificateGrantType grantType = (CertificateGrantType)super.readResource(mediaType, json);
        grantType.setType("certificate");
        this.readPublicKey(json, grantType);
        this.readAppId(json, grantType);
        return grantType;
    }

    @Nonnull
    protected CertificateGrantType createResource(@Nonnull MediaType mediaType) {
        return new CertificateGrantType();
    }

    public boolean isReadable(@Nonnull MediaType mediaType) {
        return JsonpSupport.isMediaTypeSame(SupportedMediaType.CERTIFICATE_GRANT_MT, mediaType);
    }

    @Nonnull
    public Class getResourceType() {
        return AbstractGrantType.class;
    }
}

