/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.client.password;

import com.covisint.core.http.service.client.BaseResourceClientBuilder;
import com.covisint.platform.authn.client.password.PasswordClientImpl;
import com.covisint.platform.authn.core.util.SupportedMediaType;
import com.damnhandy.uri.template.MalformedUriTemplateException;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.UriTemplateBuilder;
import com.damnhandy.uri.template.VariableExpansionException;
import com.damnhandy.uri.template.impl.VarSpec;
import com.google.common.net.MediaType;

public final class PasswordClientBuilder
extends BaseResourceClientBuilder<PasswordClientBuilder, PasswordClientImpl> {
    protected String getResourceCollectionPath() {
        return "/passwords";
    }

    protected MediaType getResourceRepresentation() {
        return MediaType.parse((String)SupportedMediaType.PASSWORD_MT.value());
    }

    protected String getExpirePasswordPath() {
        return "/passwords/tasks/expire";
    }

    protected String getLockPasswordPath() {
        return "/passwords/tasks/lock";
    }

    protected String getUnlockPasswordPath() {
        return "/passwords/tasks/unlock";
    }

    protected String getAuthenticationPath() {
        return "/passwords/tasks/authenticate";
    }

    protected String getBatchUpdateAuthnPolicyIdsPath() {
        return "/passwords/tasks/batch/update";
    }

    protected String getBatchUpdatePasswordPolicyIdsPath() {
        return "/passwords/tasks/batch/update/password";
    }

    public PasswordClientImpl build() {
        PasswordClientImpl client = (PasswordClientImpl)this.populateBaseBuilder(new PasswordClientImpl());
        try {
            UriTemplate byIdTemplate = UriTemplate.buildFromTemplate((String)this.getServiceBaseUrl()).literal(this.getResourceCollectionPath()).path(new VarSpec[]{UriTemplateBuilder.var((String)"id")}).build();
            client.setGetByIdEndpointTemplate(byIdTemplate);
            client.setUpdatePasswordTemplate(UriTemplate.buildFromTemplate((String)this.getServiceBaseUrl()).literal(this.getResourceCollectionPath()).path(new VarSpec[]{UriTemplateBuilder.var((String)"id")}).query(new String[]{"mode"}).build());
            client.setExpirePasswordTemplate(UriTemplate.buildFromTemplate((String)this.getServiceBaseUrl()).literal(this.getExpirePasswordPath()).query(new String[]{"subject"}).build());
            client.setLockPasswordTemplate(UriTemplate.buildFromTemplate((String)this.getServiceBaseUrl()).literal(this.getLockPasswordPath()).query(new String[]{"subject"}).build());
            client.setUnlockPasswordTemplate(UriTemplate.buildFromTemplate((String)this.getServiceBaseUrl()).literal(this.getUnlockPasswordPath()).query(new String[]{"subject"}).build());
            client.setAuthenticationEndpoint(UriTemplate.buildFromTemplate((String)this.getServiceBaseUrl()).literal(this.getAuthenticationPath()).build().expand());
            client.setBatchUpdateAuthnPolicyIdsTemplate(UriTemplate.buildFromTemplate((String)this.getServiceBaseUrl()).literal(this.getBatchUpdateAuthnPolicyIdsPath()).build().expand());
            client.setBatchUpdatePasswordPolicyIdsTemplate(UriTemplate.buildFromTemplate((String)this.getServiceBaseUrl()).literal(this.getBatchUpdatePasswordPolicyIdsPath()).build().expand());
            return client;
        }
        catch (MalformedUriTemplateException e) {
            throw new RuntimeException(e);
        }
        catch (VariableExpansionException e) {
            throw new IllegalStateException("Error rendering authentication endpoint", e);
        }
    }
}

