/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.client.sdk;

import com.covisint.core.http.service.core.Page;
import com.covisint.core.http.service.core.Resource;
import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.http.service.core.SortCriteria;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.httpclient.HttpClientBuilder;
import com.covisint.platform.authn.client.securityquestion.SecurityQuestionClientFactory;
import com.covisint.platform.authn.client.securityquestion.SecurityQuestionClientImpl;
import com.covisint.platform.authn.core.securityquestion.SecurityQuestion;
import com.covisint.platform.oauth.client.token.sdk.AuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.DefaultAuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.TokenSupplier;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.List;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class SecurityQuestionSDK
extends SecurityQuestionClientFactory {
    private AuthConfigurationProvider authConfigProvider;

    public SecurityQuestionSDK(@Nonnull @NotEmpty String serviceUrl) {
        super(serviceUrl);
    }

    @Nonnull
    protected AuthConfigurationProvider getAuthConfigProvider() {
        if (this.authConfigProvider == null) {
            this.authConfigProvider = new DefaultAuthConfigurationProvider();
        }
        return this.authConfigProvider;
    }

    protected HttpClientBuilder populateHttpClientBuilder(@Nonnull HttpClientBuilder builder) {
        TokenSupplier tokenSupplier = new TokenSupplier(this.getAuthConfigProvider());
        builder.addAuthorizationTokenInterceptor((Supplier)tokenSupplier);
        return builder;
    }

    public SecurityQuestionSDK setAuthConfigProvider(@Nonnull AuthConfigurationProvider provider) {
        this.authConfigProvider = provider;
        return this;
    }

    public SecurityQuestionClientImpl create() {
        throw new UnsupportedOperationException("Please use #newClient to create new client instances.");
    }

    @Nonnull
    public SecurityQuestionClient newClient() {
        return new ClientImpl((SecurityQuestionClientImpl)super.create());
    }

    private static final class ClientImpl
    implements SecurityQuestionClient {
        private final SecurityQuestionClientImpl delegate;

        private ClientImpl(@Nonnull SecurityQuestionClientImpl newDelegate) {
            this.delegate = newDelegate;
        }

        @Override
        @Nonnull
        public CheckedFuture<List<SecurityQuestion>, ServiceException> search(String ownerId, String ownerType, @Nonnull Page page) {
            ArrayListMultimap filter = ArrayListMultimap.create();
            filter.put((Object)"owner.id", (Object)ownerId);
            filter.put((Object)"owner.type", (Object)ownerType);
            return this.delegate.search((Multimap)filter, SortCriteria.NONE, page, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<SecurityQuestion, ServiceException> update(@Nonnull SecurityQuestion question) {
            return this.delegate.persist((Resource)question, (HttpContext)new BasicHttpContext());
        }
    }

    public static interface SecurityQuestionClient {
        @Nonnull
        public CheckedFuture<List<SecurityQuestion>, ServiceException> search(String var1, String var2, @Nonnull Page var3);

        @Nonnull
        public CheckedFuture<SecurityQuestion, ServiceException> update(@Nonnull SecurityQuestion var1);
    }
}

