/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.core.http.service.client;

import com.covisint.core.http.service.client.BaseResourceClient;
import com.covisint.core.http.service.client.CacheSpec;
import com.covisint.core.http.service.client.HttpProxySpec;
import com.covisint.core.http.service.core.io.EntityReader;
import com.covisint.core.http.service.core.io.EntityWriter;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NonnullElements;
import com.covisint.core.support.constraint.NotEmpty;
import com.damnhandy.uri.template.MalformedUriTemplateException;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.UriTemplateBuilder;
import com.damnhandy.uri.template.VariableExpansionException;
import com.damnhandy.uri.template.impl.VarSpec;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.http.client.HttpClient;

public abstract class BaseResourceClientBuilder<B extends BaseResourceClientBuilder, C extends BaseResourceClient> {
    private HttpClient httpClient;
    private ListeningExecutorService executor;
    private String serviceBaseUrl;
    private List<EntityReader> entityReaders = new ArrayList<EntityReader>();
    private List<EntityWriter> entityWriters = new ArrayList<EntityWriter>();
    private CacheSpec cacheSpec;
    private HttpProxySpec proxySpec;

    public abstract C build();

    protected final HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Nonnull
    public final B setHttpClient(@Nonnull HttpClient client) {
        this.httpClient = client;
        return (B)this;
    }

    protected final ListeningExecutorService getExecutorService() {
        return this.executor;
    }

    @Nonnull
    public final B setExecutorService(@Nonnull ListeningExecutorService service) {
        this.executor = service;
        return (B)this;
    }

    protected final String getServiceBaseUrl() {
        return this.serviceBaseUrl;
    }

    @Nonnull
    public final B setServiceBaseUrl(@Nonnull @NotEmpty String url) {
        this.serviceBaseUrl = url;
        return (B)this;
    }

    public final List<EntityReader> getEntityReaders() {
        return this.entityReaders;
    }

    public final B setEntityReaders(Collection<EntityReader> readers) {
        return this.setEntityReaders(Lists.newArrayList((Iterable)Iterables.filter(readers, (Predicate)Predicates.notNull())));
    }

    public final B setEntityReaders(@Nonnull @NonnullElements List<EntityReader> readers) {
        this.entityReaders = readers;
        return (B)this;
    }

    public final B addEntityReader(EntityReader reader) {
        if (reader != null) {
            this.entityReaders.add(reader);
        }
        return (B)this;
    }

    public final List<EntityWriter> getEntityWriters() {
        return this.entityWriters;
    }

    public final B setEntityWriters(Collection<EntityWriter> writers) {
        return this.setEntityWriters(Lists.newArrayList((Iterable)Iterables.filter(writers, (Predicate)Predicates.notNull())));
    }

    public final B setEntityWriters(@Nonnull @NonnullElements List<EntityWriter> writers) {
        this.entityWriters = writers;
        return (B)this;
    }

    public final B addEntityWriter(EntityWriter writer) {
        if (writer != null) {
            this.entityWriters.add(writer);
        }
        return (B)this;
    }

    protected final CacheSpec getCacheSpec() {
        return this.cacheSpec;
    }

    public final B setCacheSpec(CacheSpec config) {
        if (config != null) {
            this.cacheSpec = config;
        }
        return (B)this;
    }

    protected final HttpProxySpec getHttpProxySpec() {
        return this.proxySpec;
    }

    public final B setHttpProxySpec(HttpProxySpec config) {
        if (config != null) {
            this.proxySpec = config;
        }
        return (B)this;
    }

    @Nonnull
    protected abstract String getResourceCollectionPath();

    @Nonnull
    protected abstract MediaType getResourceRepresentation();

    protected C populateBaseBuilder(C client) {
        ((BaseResourceClient)client).setEntityReaders(this.entityReaders);
        ((BaseResourceClient)client).setEntityWriters(this.entityWriters);
        ((BaseResourceClient)client).setHttpClient(this.httpClient);
        ((BaseResourceClient)client).setExecutorService(this.executor);
        ((BaseResourceClient)client).setCrudContentType(this.getResourceRepresentation());
        if (this.cacheSpec != null) {
            ((BaseResourceClient)client).configureCache(this.cacheSpec);
        }
        this.setCrudEndpoints(client);
        return client;
    }

    private void setCrudEndpoints(C client) {
        if (this.serviceBaseUrl == null) {
            throw new IllegalStateException("No service base URL has not been specified");
        }
        try {
            UriTemplate serviceCollectionBase = UriTemplate.buildFromTemplate((String)this.serviceBaseUrl).literal(this.getResourceCollectionPath()).build();
            ((BaseResourceClient)client).setAddEndpoint(serviceCollectionBase.expand());
            ((BaseResourceClient)client).setSearchEndpoint(serviceCollectionBase.expand());
            UriTemplate byIdTemplate = UriTemplate.buildFromTemplate((UriTemplate)serviceCollectionBase).path(new VarSpec[]{UriTemplateBuilder.var((String)"id")}).build();
            ((BaseResourceClient)client).setGetByIdEndpointTemplate(byIdTemplate);
            ((BaseResourceClient)client).setUpdateEndpointTemplate(byIdTemplate);
            ((BaseResourceClient)client).setDeleteEndpointTemplate(byIdTemplate);
        }
        catch (MalformedUriTemplateException e) {
            throw new IllegalStateException("Error creating service endpoint templates", e);
        }
        catch (VariableExpansionException e) {
            throw new IllegalStateException("Error rendering static service endpoints", e);
        }
    }
}

