/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.core.http.service.client;

import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.google.common.base.Objects;

public final class HttpProxySpec {
    private final String host;
    private final int port;
    private String username;
    private String password;

    public HttpProxySpec(@Nonnull @NotEmpty String newHost, int newPort) {
        this.host = newHost;
        this.port = newPort;
    }

    public HttpProxySpec setCredentials(@Nonnull @NotEmpty String newUsername, @Nonnull @NotEmpty String newPassword) {
        this.username = newUsername;
        this.password = newPassword;
        return this;
    }

    @Nonnull
    @NotEmpty
    public String getHost() {
        return this.host;
    }

    @Nonnull
    @NotEmpty
    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.host, this.port, this.username, this.password});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HttpProxySpec)) {
            return false;
        }
        HttpProxySpec that = (HttpProxySpec)obj;
        return Objects.equal((Object)this.host, (Object)that.host) && this.port == that.port && Objects.equal((Object)this.username, (Object)that.username) && Objects.equal((Object)this.password, (Object)that.password);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("host", (Object)this.host).add("port", this.port).add("username", (Object)this.username).add("password", (Object)this.password).toString();
    }
}

