/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.account.securityquestion.io.jsonp;

import com.covisint.core.http.service.core.AbstractRealmScopedResource;
import com.covisint.core.http.service.core.io.jsonp.AbstractRealmScopedResourceWriter;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NonnullElements;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.platform.authn.core.account.securityquestion.SecurityQuestionAccount;
import com.covisint.platform.authn.core.util.JsonpSupport;
import com.covisint.platform.authn.core.util.SupportedMediaType;
import com.google.common.net.MediaType;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;

public class SecurityQuestionAccountWriter
extends AbstractRealmScopedResourceWriter<SecurityQuestionAccount> {
    private void writeQuestions(@Nonnull @NonnullElements List<SecurityQuestionAccount.Question> questions, @Nonnull JsonObjectBuilder builder) {
        JsonArrayBuilder questionsArrayBuilder = Json.createArrayBuilder();
        for (SecurityQuestionAccount.Question question : questions) {
            JsonObjectBuilder questionBuilder = Json.createObjectBuilder();
            this.writeResourceReference("question", question.getQuestion(), questionBuilder);
            if (question.getAnswer() != null) {
                questionBuilder.add("answer", question.getAnswer());
            }
            if (question.getIndex() > 0) {
                questionBuilder.add("index", question.getIndex());
            }
            questionsArrayBuilder.add(questionBuilder);
        }
        builder.add("questions", questionsArrayBuilder);
    }

    @Nonnull
    protected final JsonObjectBuilder writeResource(@Nonnull MediaType mediaType, @Nonnull SecurityQuestionAccount resource) {
        JsonObjectBuilder builder = super.writeResource(mediaType, (AbstractRealmScopedResource)resource);
        this.writeQuestions(resource.getQuestions(), builder);
        return builder;
    }

    @Nonnull
    public final Class<SecurityQuestionAccount> getResourceType() {
        return SecurityQuestionAccount.class;
    }

    public final boolean isWritable(@Nullable Class clazz, @Nonnull MediaType mediaType) {
        return JsonpSupport.isMediaTypeSame(SupportedMediaType.SECURITY_QUESTION_ACCOUNT_MT, mediaType);
    }
}

