/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.password;

import com.covisint.core.support.constraint.Constraints;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.core.support.primitive.StringSupport;
import com.covisint.platform.authn.core.password.AbstractPassword;
import com.google.common.base.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;

@Entity
@Table(name="password")
@NamedQueries(value={@NamedQuery(name="Password.findAll", query="SELECT p FROM Password p where p.realm = :realm"), @NamedQuery(name="Password.deleteAll", query="DELETE FROM Password p where p.realm = :realm"), @NamedQuery(name="Password.countAll", query="SELECT COUNT(*) FROM Password p where p.realm = :realm"), @NamedQuery(name="Password.exists", query="SELECT p FROM Password p WHERE p.subject = :subject and p.realm = :realm"), @NamedQuery(name="Password.updateAuthPolicyId", query="UPDATE Password p SET p.authnPolicyId = :authnPolicyId WHERE p.subject IN (:subject) and p.realm = :realm"), @NamedQuery(name="Password.getAllLockedPasswords", query="SELECT p FROM Password p WHERE p.isLocked = 1 and p.realm = :realm")})
public class Password
extends AbstractPassword<Password> {
    private static final long serialVersionUID = 4627703394289095685L;
    @Transient
    private String hashAlgorithm;
    @Version
    @Column(name="VERSION", nullable=false, precision=10)
    private Long version;

    @Nullable
    public Long getVersion() {
        return this.version;
    }

    public Password setVersion(@Nonnull Long aVersion) {
        this.version = Constraints.isGreaterThanOrEqual((long)0L, (long)aVersion, (String)"Version may not be negative.");
        return this;
    }

    @Nullable
    public String getHashAlgorithm() {
        String pw;
        if (StringSupport.trimOrNull((String)this.hashAlgorithm) == null && StringSupport.trimOrNull((String)(pw = this.getHashedPassword())) != null) {
            if (!pw.startsWith("{")) {
                throw new IllegalStateException("The given ciphertext does not start with an algorithm identifier");
            }
            this.hashAlgorithm = pw.substring(1, pw.indexOf("}"));
        }
        return this.hashAlgorithm;
    }

    public void setHashAlgorithm(@Nonnull String newHashAlgorithm) {
        this.hashAlgorithm = newHashAlgorithm;
    }

    public String toString() {
        return this.populateToStringHelper(Objects.toStringHelper((Object)this)).add("hashingAlgorithm", (Object)this.getHashAlgorithm()).toString();
    }
}

