/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.password.authenticate;

import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.platform.authn.core.password.authenticate.PasswordAuthenticationRequest;
import com.covisint.platform.authn.core.password.authenticate.PasswordAuthenticationResponse;
import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="PASSWORD_AUTHN_AUDIT")
public class PasswordAuthenticationAuditEntry
implements Serializable {
    private static final long serialVersionUID = -671142177831122907L;
    @Id
    @Column(name="REQUEST_INSTANT", nullable=false, scale=19)
    private long requestInstant;
    @Id
    @Column(name="REQUESTER", nullable=false, length=128)
    private String requestorService;
    @Id
    @Column(name="SUBJECT", nullable=false, length=64)
    private String subject;
    @Column(name="SUBJECT_IP_ADDR", nullable=false, length=64)
    private String subjectInetAddress;
    @Column(name="RESULT", nullable=false, length=16)
    @Enumerated(value=EnumType.STRING)
    private PasswordAuthenticationResponse.Result result;

    public PasswordAuthenticationAuditEntry() {
    }

    public PasswordAuthenticationAuditEntry(@Nonnull PasswordAuthenticationRequest request, @Nonnull PasswordAuthenticationResponse response) {
        this.requestInstant = request.getRequestInstant();
        this.requestorService = request.getRequestorService();
        this.subject = request.getSubject();
        this.subjectInetAddress = request.getSubjectInetAddress();
        this.result = response.getAuthenticationResult();
    }

    public long getRequestInstant() {
        return this.requestInstant;
    }

    @Nullable
    public String getRequestorService() {
        return this.requestorService;
    }

    @Nullable
    public String getSubject() {
        return this.subject;
    }

    @Nullable
    public String getSubjectInetAddress() {
        return this.subjectInetAddress;
    }

    @Nullable
    public PasswordAuthenticationResponse.Result getAuthenticationResult() {
        return this.result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PasswordAuthenticationAuditEntry)) {
            return false;
        }
        PasswordAuthenticationAuditEntry that = (PasswordAuthenticationAuditEntry)obj;
        return Objects.equals(this.requestInstant, that.requestInstant) && Objects.equals(this.requestorService, that.requestorService) && Objects.equals(this.subject, that.subject) && Objects.equals(this.subjectInetAddress, that.subjectInetAddress) && Objects.equals((Object)this.result, (Object)that.result);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.requestInstant, this.requestorService, this.subject, this.subjectInetAddress, this.result});
    }
}

