/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.password.authenticate;

import com.covisint.core.http.service.core.io.EntityParsingException;
import com.covisint.core.http.service.core.io.EntityReader;
import com.covisint.core.http.service.core.io.EntityReaderException;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.platform.authn.core.password.authenticate.PasswordAuthenticationRequestReader;
import com.covisint.platform.authn.core.password.authenticate.PasswordAuthenticationResponse;
import com.covisint.platform.authn.core.util.JsonpSupport;
import com.covisint.platform.authn.core.util.SupportedMediaType;
import com.google.common.net.MediaType;
import java.io.InputStream;
import java.util.Scanner;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonParsingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordAuthenticationResponseReader
implements EntityReader<PasswordAuthenticationResponse> {
    private static final PasswordAuthenticationRequestReader requestCodec = new PasswordAuthenticationRequestReader();
    private final Logger log = LoggerFactory.getLogger(PasswordAuthenticationResponseReader.class);

    @Nonnull
    public Class<PasswordAuthenticationResponse> getResourceType() {
        return PasswordAuthenticationResponse.class;
    }

    public boolean isReadable(@Nonnull MediaType mediaType) {
        return JsonpSupport.isMediaTypeSame(SupportedMediaType.PASSWORD_AUTHN_REPONSE_MT, mediaType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PasswordAuthenticationResponse read(@Nonnull MediaType mediaType, @Nonnull InputStream input) {
        this.log.debug("Preparing to parse JSON data from inputstream");
        try (JsonReader jsonReader = Json.createReader((InputStream)input);){
            JsonString result;
            JsonStructure json = jsonReader.read();
            if (!JsonValue.ValueType.OBJECT.equals((Object)json.getValueType())) {
                throw new EntityReaderException("Unsupported source JSON type of " + json.getValueType().toString());
            }
            JsonObject respJson = (JsonObject)json;
            PasswordAuthenticationResponse authnResp = new PasswordAuthenticationResponse();
            if (respJson.containsKey((Object)"instant")) {
                authnResp.setAuthenticationInstant(respJson.getJsonNumber("instant").longValue());
            }
            if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(result = respJson.getJsonString("result")))) {
                authnResp.setAuthenticationResult(PasswordAuthenticationResponse.Result.valueOf(result.getString().toUpperCase()));
            }
            if (respJson.containsKey((Object)"request")) {
                authnResp.setAuthenticationRequest(requestCodec.readResource(respJson.getJsonObject("request")));
            }
            PasswordAuthenticationResponse passwordAuthenticationResponse = authnResp;
            return passwordAuthenticationResponse;
        }
        catch (JsonParsingException e) {
            this.log.debug("Invalid JSON, unable to parse", (Throwable)e);
            throw new EntityParsingException(e.getLocation().getLineNumber(), e.getLocation().getColumnNumber(), (Throwable)e);
        }
        catch (JsonException e) {
            try (Scanner scanner = new Scanner(input);){
                if (!scanner.hasNext()) {
                    PasswordAuthenticationResponse respJson = new PasswordAuthenticationResponse();
                    return respJson;
                }
            }
            this.log.debug("Unable to parse JSON", (Throwable)e);
            throw new EntityReaderException("Unable to parse JSON");
        }
    }
}

