/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.password.io.jsonp;

import com.covisint.core.http.service.core.AbstractResource;
import com.covisint.core.http.service.core.io.jsonp.AbstractResourceWriter;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.platform.authn.core.password.PasswordBatchUpdateRequest;
import com.covisint.platform.authn.core.util.JsonpSupport;
import com.covisint.platform.authn.core.util.SupportedMediaType;
import com.google.common.collect.Multimap;
import com.google.common.net.MediaType;
import java.util.Collection;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;

public class PasswordBatchUpdateRequestWriter
extends AbstractResourceWriter<PasswordBatchUpdateRequest> {
    @Nonnull
    protected JsonObjectBuilder writeResource(@Nonnull MediaType mediaType, @Nonnull PasswordBatchUpdateRequest passwordReq) {
        Collection subjects;
        JsonArrayBuilder subjectBuilder;
        JsonObjectBuilder builder = super.writeResource(mediaType, (AbstractResource)passwordReq);
        builder.add("instant", passwordReq.getRequestInstant());
        if (passwordReq.getAuthnPolicyIdSubjects() != null) {
            JsonObjectBuilder authnEntryBuilder = Json.createObjectBuilder();
            subjectBuilder = Json.createArrayBuilder();
            Multimap<String, String> authnPolicyIdMap = passwordReq.getAuthnPolicyIdSubjects();
            for (String key : authnPolicyIdMap.keySet()) {
                subjects = authnPolicyIdMap.get((Object)key);
                for (String subject : subjects) {
                    subjectBuilder.add(subject);
                }
                authnEntryBuilder.add(key, subjectBuilder);
            }
            builder.add("authnPolicyIdSubjects", authnEntryBuilder);
        }
        if (passwordReq.getPasswordPolicyIdSubjects() != null) {
            JsonObjectBuilder passwordEntryBuilder = Json.createObjectBuilder();
            subjectBuilder = Json.createArrayBuilder();
            Multimap<String, String> passwordPolicyIdMap = passwordReq.getPasswordPolicyIdSubjects();
            for (String key : passwordPolicyIdMap.keySet()) {
                subjects = passwordPolicyIdMap.get((Object)key);
                for (String subject : subjects) {
                    subjectBuilder.add(subject);
                }
                passwordEntryBuilder.add(key, subjectBuilder);
            }
            builder.add("passwordPolicyIdSubjects", passwordEntryBuilder);
        }
        return builder;
    }

    @Nonnull
    public Class<PasswordBatchUpdateRequest> getResourceType() {
        return PasswordBatchUpdateRequest.class;
    }

    public boolean isWritable(@Nonnull Class clazz, @Nonnull MediaType mediaType) {
        return JsonpSupport.isMediaTypeSame(SupportedMediaType.PASSWORD_BATCH_REQUEST_MT, mediaType);
    }
}

