/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.password.io.jsonp;

import com.covisint.core.http.service.core.io.EntityParsingException;
import com.covisint.core.http.service.core.io.EntityReader;
import com.covisint.core.http.service.core.io.EntityReaderException;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NonnullElements;
import com.covisint.platform.authn.core.password.Password;
import com.covisint.platform.authn.core.util.JsonpSupport;
import com.covisint.platform.authn.core.util.SupportedMediaType;
import com.google.common.net.MediaType;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonParsingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordReader
implements EntityReader<Object> {
    private final Logger log = LoggerFactory.getLogger(PasswordReader.class);

    @Nonnull
    @NonnullElements
    protected List<Password> readResourceArray(@Nonnull MediaType mediaType, @Nonnull JsonArray jsonArray) {
        ArrayList<Password> resources = new ArrayList<Password>();
        for (JsonValue jsonElement : jsonArray) {
            if (com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isObject((JsonValue)jsonElement)) {
                resources.add(this.readResource(mediaType, (JsonObject)jsonElement));
                continue;
            }
            if (com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isNull((JsonValue)jsonElement)) {
                this.log.debug("JSON array contained a null element, ignoring it");
                continue;
            }
            this.log.debug("{} JSON structure is not supported within the root-level array", (Object)jsonElement.getValueType().toString());
            throw new EntityReaderException(jsonElement.getValueType().toString() + " JSON structure of is not supported in root-level array.");
        }
        return resources;
    }

    @Nonnull
    protected Password readResource(@Nonnull MediaType mediaType, @Nonnull JsonObject json) {
        JsonNumber numberProperty;
        JsonObject passwordJson;
        JsonString stringValue;
        this.log.debug("About to unmarshall the following JSON representation: {}", (Object)json.toString());
        Password password = this.createResource(mediaType);
        JsonNumber numberValue = json.getJsonNumber("version");
        if (numberValue != null) {
            password.setVersion(numberValue.longValue());
        }
        if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(stringValue = json.getJsonString("creator")))) {
            password.setCreator(stringValue.getString());
        }
        if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(stringValue = json.getJsonString("realm")))) {
            password.setRealm(stringValue.getString());
        }
        numberValue = json.getJsonNumber("creation");
        if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)stringValue)) {
            password.setCreationInstant(numberValue.longValue());
        }
        if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(stringValue = (passwordJson = json).getJsonString("subject")))) {
            password.setSubjectId(stringValue.getString());
        }
        if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(stringValue = passwordJson.getJsonString("passwordPolicyId")))) {
            password.setPasswordPolicyId(stringValue.getString());
        }
        if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(stringValue = passwordJson.getJsonString("authenticationPolicyId")))) {
            password.setAuthnPolicyId(stringValue.getString());
        }
        if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(stringValue = passwordJson.getJsonString("currentPassword")))) {
            password.setCurrentPassword(stringValue.getString());
        }
        if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(stringValue = passwordJson.getJsonString("password")))) {
            password.setNewPassword(stringValue.getString());
        }
        if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(stringValue = passwordJson.getJsonString("hashAlgorithm")))) {
            password.setHashAlgorithm(stringValue.getString());
        }
        if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(stringValue = passwordJson.getJsonString("hashedPassword")))) {
            password.setHashedPassword(stringValue.getString());
        }
        if ((numberProperty = passwordJson.getJsonNumber("expiration")) != null) {
            password.setExpirationInstant(numberProperty.longValue());
        }
        if ((numberProperty = passwordJson.getJsonNumber("unlockInstant")) != null) {
            password.setUnlockInstant(numberProperty.longValue());
        }
        password.setLocked(passwordJson.getBoolean("locked", false));
        this.log.debug("Successfully unmarshalled JSON to: {}", (Object)password);
        return password;
    }

    @Nonnull
    protected Password createResource(@Nonnull MediaType mediaType) {
        return new Password();
    }

    @Nonnull
    public Class getResourceType() {
        return Password.class;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object read(@Nonnull MediaType mediaType, @Nonnull InputStream input) {
        this.log.debug("Preparing to parse JSON data from inputstream");
        try (JsonReader jsonReader = Json.createReader((InputStream)input);){
            JsonStructure json = jsonReader.read();
            this.log.debug("Parsed a JSON structure of type {}", (Object)json.getValueType().toString());
            if (com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isArray((JsonValue)json)) {
                List<Password> list = this.readResourceArray(mediaType, (JsonArray)json);
                return list;
            }
            if (com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isObject((JsonValue)json)) {
                Password password = this.readResource(mediaType, (JsonObject)json);
                return password;
            }
            this.log.debug("Root-level JSON structure of type {} is not supported by this reader", (Object)json.getValueType().toString());
            throw new EntityReaderException("Root-level JSON structure of " + json.getValueType().toString() + " is not supported.");
        }
        catch (JsonParsingException e) {
            this.log.debug("Invalid JSON, unable to parse", (Throwable)e);
            throw new EntityParsingException(e.getLocation().getLineNumber(), e.getLocation().getColumnNumber(), (Throwable)e);
        }
        catch (JsonException e) {
            try (Scanner scanner = new Scanner(input);){
                if (!scanner.hasNext()) {
                    Password password = this.createResource(mediaType);
                    return password;
                }
            }
            this.log.debug("Unable to parse JSON", (Throwable)e);
            throw new EntityReaderException("Unable to parse JSON");
        }
    }

    public boolean isReadable(@Nonnull MediaType mediaType) {
        return JsonpSupport.isMediaTypeSame(SupportedMediaType.PASSWORD_MT, mediaType);
    }
}

