/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.password.io.jsonp;

import com.covisint.core.http.service.core.io.EntityWriter;
import com.covisint.core.http.service.core.io.EntityWriterException;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.platform.authn.core.password.Password;
import com.covisint.platform.authn.core.util.JsonpSupport;
import com.covisint.platform.authn.core.util.SupportedMediaType;
import com.google.common.base.Charsets;
import com.google.common.net.MediaType;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordWriter
implements EntityWriter<Object> {
    private final Logger log = LoggerFactory.getLogger(PasswordWriter.class);

    @Nonnull
    private JsonWriterFactory createWriterFactory(@Nonnull MediaType mediaType) {
        this.log.debug("Creating JSON writer factory");
        HashMap<String, Boolean> writerConfig = new HashMap<String, Boolean>();
        writerConfig.put("javax.json.stream.JsonGenerator.prettyPrinting", false);
        return Json.createWriterFactory(writerConfig);
    }

    @Nonnull
    protected JsonObjectBuilder writeResource(@Nonnull MediaType mediaType, @Nonnull Password password) {
        JsonObjectBuilder jsonBuilder = Json.createObjectBuilder();
        if (password.getVersion() != null) {
            jsonBuilder.add("version", password.getVersion().longValue());
        }
        com.covisint.core.http.service.core.io.jsonp.JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)jsonBuilder, (String)"creator", (String)password.getCreator());
        com.covisint.core.http.service.core.io.jsonp.JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)jsonBuilder, (String)"creatorAppId", (String)password.getCreatorApplicationId());
        jsonBuilder.add("creation", password.getCreationInstant());
        com.covisint.core.http.service.core.io.jsonp.JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)jsonBuilder, (String)"realm", (String)password.getRealm());
        com.covisint.core.http.service.core.io.jsonp.JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)jsonBuilder, (String)"subject", (String)password.getSubjectId());
        com.covisint.core.http.service.core.io.jsonp.JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)jsonBuilder, (String)"hashAlgorithm", (String)password.getHashAlgorithm());
        com.covisint.core.http.service.core.io.jsonp.JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)jsonBuilder, (String)"hashedPassword", (String)password.getHashedPassword());
        com.covisint.core.http.service.core.io.jsonp.JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)jsonBuilder, (String)"currentPassword", (String)password.getCurrentPassword());
        com.covisint.core.http.service.core.io.jsonp.JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)jsonBuilder, (String)"password", (String)password.getNewPassword());
        com.covisint.core.http.service.core.io.jsonp.JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)jsonBuilder, (String)"passwordPolicyId", (String)password.getPasswordPolicyId());
        com.covisint.core.http.service.core.io.jsonp.JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)jsonBuilder, (String)"authenticationPolicyId", (String)password.getAuthnPolicyId());
        jsonBuilder.add("expiration", password.getExpirationInstant());
        jsonBuilder.add("locked", password.isLocked());
        jsonBuilder.add("unlockInstant", password.getUnlockInstant());
        return jsonBuilder;
    }

    @Nonnull
    public Class getResourceType() {
        return Password.class;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MediaType write(@Nonnull MediaType mediaType, @Nonnull Object source, @Nonnull OutputStream output) {
        JsonObject json;
        this.log.debug("Preparing to write an object of type {}, into a JSON structure", (Object)source.getClass().getName());
        if (!Collection.class.isInstance(source)) {
            if (!this.getResourceType().isAssignableFrom(source.getClass())) {
                throw new EntityWriterException("The server is unable to produce content of type");
            }
            json = this.writeResource(mediaType, (Password)source).build();
        } else {
            this.log.debug("Create JSON array for collection of resources");
            JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
            for (Object resource : (Collection)source) {
                if (resource == null) {
                    this.log.debug("Encountered null element in collection, skipping it");
                    continue;
                }
                if (!this.getResourceType().isAssignableFrom(resource.getClass())) {
                    throw new EntityWriterException("The server is unable to produce content of type");
                }
                jsonArrayBuilder.add(this.writeResource(mediaType, (Password)resource));
            }
            json = jsonArrayBuilder.build();
        }
        this.log.debug("A JSON structure of type {} was created for an object of type {}", (Object)json.getValueType().toString(), (Object)source.getClass().getName());
        JsonWriterFactory factory = this.createWriterFactory(mediaType);
        try (JsonWriter writer = factory.createWriter(output, Charsets.UTF_8);){
            this.log.debug("Writing JSON to output stream");
            writer.write((JsonStructure)json);
            MediaType mediaType2 = mediaType;
            return mediaType2;
        }
        catch (IllegalStateException | JsonException e) {
            this.log.debug("Unable to write JSON to output stream", e);
            throw new EntityWriterException("Unable to write JSON");
        }
    }

    public boolean isWritable(@Nonnull Class klass, @Nonnull MediaType mediaType) {
        return JsonpSupport.isMediaTypeSame(SupportedMediaType.PASSWORD_MT, mediaType);
    }
}

