/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.password.policy;

import com.covisint.core.support.constraint.Constraints;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.platform.authn.core.password.policy.Operation;
import com.covisint.platform.authn.core.password.policy.PasswordPolicy;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public abstract class AbstractPolicyRule
implements Serializable {
    private static final long serialVersionUID = 4196741840357109426L;
    @Id
    @Column(length=64, nullable=false)
    private String type;
    @Id
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="POLICY_ID", nullable=false)
    private PasswordPolicy passwordPolicy;

    protected AbstractPolicyRule() {
    }

    protected AbstractPolicyRule(String ruleType) {
        this.type = ruleType;
    }

    protected void setType(String newType) {
        this.type = newType;
    }

    @Nullable
    public PasswordPolicy getPasswordPolicy() {
        return this.passwordPolicy;
    }

    public void setPasswordPolicy(PasswordPolicy newPasswordPolicy) {
        this.passwordPolicy = newPasswordPolicy;
    }

    @Nullable
    public final String getType() {
        return this.type;
    }

    public boolean executesFor(@Nonnull Operation operation) {
        return this.executesForAny(EnumSet.of(operation));
    }

    public boolean executesForAny(@Nonnull EnumSet<Operation> operations) {
        EnumSet<Operation> mappedOperations = this.getSupportedOperations();
        Constraints.isNotNull(mappedOperations, (String)"Set of mapped operations may not be null.");
        for (Operation operation : operations) {
            if (!this.getSupportedOperations().contains((Object)operation)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.passwordPolicy.getId(), this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractPolicyRule other = (AbstractPolicyRule)obj;
        return Objects.equal((Object)this.passwordPolicy.getId(), (Object)other.passwordPolicy.getId()) && Objects.equal((Object)this.type, (Object)other.type);
    }

    public abstract String getDescription(List<String> var1);

    @Nonnull
    @NotEmpty
    public abstract EnumSet<Operation> getSupportedOperations();
}

