/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.password.policy;

import com.covisint.core.support.constraint.Constraints;
import com.covisint.platform.authn.core.password.policy.AbstractPolicyRule;
import com.covisint.platform.authn.core.password.policy.Operation;
import com.covisint.platform.authn.core.util.LanguageManager;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name="HISTORY_RULE")
public class HistoryRule
extends AbstractPolicyRule
implements Serializable {
    public static final String RULE_TYPE = "HISTORY";
    private static final long serialVersionUID = -2531075969843906266L;
    @Column(name="NUMBER_OF_PASSWORDS", scale=2, nullable=false)
    private int numberOfPasswords;

    public HistoryRule() {
        super(RULE_TYPE);
    }

    public int getNumberOfPasswords() {
        return this.numberOfPasswords;
    }

    public void setNumberOfPasswords(int newNumberOfPasswords) {
        this.numberOfPasswords = (int)Constraints.numberInRangeInclusive((long)0L, (long)10L, (long)newNumberOfPasswords, (String)"Number of Passwords must be between 0 and 10.");
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("numberOfPasswords", this.numberOfPasswords).toString();
    }

    @Override
    public String getDescription(List<String> languageTags) {
        return String.format(LanguageManager.getText("PASSWORD_HISTORY_DESCRIPTION", languageTags), this.getNumberOfPasswords());
    }

    @Override
    public EnumSet<Operation> getSupportedOperations() {
        return EnumSet.of(Operation.PASSWORD_CHANGE, Operation.PASSWORD_RESET, Operation.PASSWORD_SPECIFY, Operation.EXPIRED_PASSWORD_CHANGE);
    }
}

