/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.password.policy;

import com.covisint.core.support.constraint.Constraints;
import com.covisint.platform.authn.core.password.policy.AbstractPolicyRule;
import com.covisint.platform.authn.core.password.policy.Operation;
import com.covisint.platform.authn.core.util.LanguageManager;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="LENGTH_RULE")
public class LengthRule
extends AbstractPolicyRule
implements Serializable {
    public static final String RULE_TYPE = "LENGTH";
    private static final Logger LOGGER = LoggerFactory.getLogger(LengthRule.class);
    private static final long serialVersionUID = -5677683640150774059L;
    @Column(name="MINIMUM", nullable=false, scale=2)
    private int minimumLength;
    @Column(name="MAXIMUM", nullable=false, scale=2)
    private int maximumLength;

    public LengthRule() {
        super(RULE_TYPE);
    }

    public int getMinimumLength() {
        return this.minimumLength;
    }

    public void setMinimumLength(int newMinimumLength) {
        this.minimumLength = (int)Constraints.isGreaterThan((long)0L, (long)newMinimumLength, (String)"Minimum Length must be greater than 0");
    }

    public int getMaximumLength() {
        return this.maximumLength;
    }

    public void setMaximumLength(int newMaximumLength) {
        this.maximumLength = (int)Constraints.isGreaterThanOrEqual((long)this.minimumLength, (long)newMaximumLength, (String)"Maximum Length cannot be less than Minimum Length");
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("minimumLength", this.minimumLength).add("maximumLength", this.maximumLength).toString();
    }

    @Override
    public String getDescription(List<String> languageTags) {
        LOGGER.debug("getDescription starting..");
        String description = LanguageManager.getText("PASSWORD_LENGTH_DESCRIPTION", languageTags);
        LOGGER.debug("getDescription description from LanguageManager is " + description);
        return String.format(description, this.getMinimumLength(), this.getMaximumLength());
    }

    @Override
    public EnumSet<Operation> getSupportedOperations() {
        return EnumSet.of(Operation.AUTHENTICATE, Operation.PASSWORD_CHANGE, Operation.PASSWORD_RESET, Operation.PASSWORD_SPECIFY, Operation.EXPIRED_PASSWORD_CHANGE);
    }
}

