/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.password.policy;

import com.covisint.platform.authn.core.password.policy.AbstractPolicyRule;
import com.covisint.platform.authn.core.password.policy.Operation;
import com.covisint.platform.authn.core.util.LanguageManager;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name="PASSWORD_LIFETIME_RULE")
public final class LifetimeRule
extends AbstractPolicyRule
implements Serializable {
    public static final String RULE_TYPE = "LIFETIME";
    private static final long serialVersionUID = -1221482276748541719L;
    @Column(name="MAX_LIFETIME", scale=10, nullable=false)
    private long maxLifetime = 90L;
    @Column(name="MIN_LIFETIME", scale=10, nullable=false)
    private long minLifetime = 1L;

    public LifetimeRule() {
        super(RULE_TYPE);
    }

    public long getMinLifetime() {
        return this.minLifetime;
    }

    public void setMinLifetime(long lifetime) {
        this.minLifetime = lifetime < 1L ? 0L : lifetime;
    }

    public long getMaxLifetime() {
        return this.maxLifetime;
    }

    public void setMaxLifetime(long lifetime) {
        this.maxLifetime = lifetime < 1L ? 0L : lifetime;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("minLifetime", this.minLifetime).add("maxLifetime", this.maxLifetime).toString();
    }

    @Override
    public String getDescription(List<String> languageTags) {
        return String.format(LanguageManager.getText("PASSWORD_LIFETIME_DESCRIPTION", languageTags), this.minLifetime);
    }

    @Override
    public EnumSet<Operation> getSupportedOperations() {
        return EnumSet.of(Operation.PASSWORD_CHANGE);
    }
}

