/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.password.policy.io.jsonp;

import com.covisint.core.http.service.core.io.EntityParsingException;
import com.covisint.core.http.service.core.io.EntityReader;
import com.covisint.core.http.service.core.io.EntityReaderException;
import com.covisint.core.http.service.core.io.jsonp.JsonpSupport;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.platform.authn.core.password.policy.AbstractPolicyRule;
import com.google.common.net.MediaType;
import java.io.InputStream;
import java.util.Scanner;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonParsingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPasswordPolicyRuleReader
implements EntityReader<AbstractPolicyRule> {
    private final Logger log = LoggerFactory.getLogger(AbstractPasswordPolicyRuleReader.class);

    @Nonnull
    protected abstract AbstractPolicyRule createResource(@Nonnull MediaType var1);

    protected abstract AbstractPolicyRule readResource(@Nonnull JsonObject var1);

    @Nonnull
    public abstract String getRuleType();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final AbstractPolicyRule read(@Nonnull MediaType mt, @Nonnull InputStream input) {
        this.log.debug("Preparing to parse JSON data from inputstream");
        try (JsonReader jsonReader = Json.createReader((InputStream)input);){
            JsonStructure json = jsonReader.read();
            this.log.debug("Parsed a JSON structure of type {}", (Object)json.getValueType().toString());
            if (JsonpSupport.isObject((JsonValue)json)) {
                AbstractPolicyRule abstractPolicyRule = this.readResource((JsonObject)json);
                return abstractPolicyRule;
            }
            throw new EntityReaderException("This JSON structure of " + json.getValueType().toString() + " is not supported.");
        }
        catch (JsonParsingException e) {
            throw new EntityParsingException(e.getLocation().getLineNumber(), e.getLocation().getColumnNumber(), (Throwable)e);
        }
        catch (JsonException e) {
            try (Scanner scannerInput = new Scanner(input);){
                if (scannerInput.hasNext()) throw new EntityReaderException("Unable to parse this JSON");
                AbstractPolicyRule abstractPolicyRule = this.createResource(mt);
                return abstractPolicyRule;
            }
        }
    }
}

