/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.password.policy.io.jsonp;

import com.covisint.core.support.constraint.Nonnull;
import com.covisint.platform.authn.core.password.policy.AbstractPolicyRule;
import com.covisint.platform.authn.core.password.policy.CharacterClassRule;
import com.covisint.platform.authn.core.password.policy.io.jsonp.AbstractPasswordPolicyRuleWriter;
import com.google.common.net.MediaType;
import javax.json.Json;
import javax.json.JsonObjectBuilder;

public final class CharacterClassRuleWriter
extends AbstractPasswordPolicyRuleWriter {
    @Override
    protected JsonObjectBuilder writeResource(@Nonnull AbstractPolicyRule rule) {
        JsonObjectBuilder jsonBuilder = Json.createObjectBuilder();
        CharacterClassRule charRule = (CharacterClassRule)rule;
        jsonBuilder.add("allowUpperChars", charRule.isUppercaseAllowed());
        jsonBuilder.add("allowLowerChars", charRule.isLowercaseAllowed());
        jsonBuilder.add("allowNumChars", charRule.isNumberAllowed());
        jsonBuilder.add("allowSpecialChars", charRule.isSpecialAllowed());
        jsonBuilder.add("requiredNumberOfCharClasses", charRule.getNumberRequired());
        return jsonBuilder;
    }

    @Nonnull
    public Class getResourceType() {
        return CharacterClassRule.class;
    }

    public boolean isWritable(@Nonnull Class klass, @Nonnull MediaType mediaType) {
        return true;
    }

    @Override
    public String getRuleType() {
        return "CHARACTER_CLASS";
    }
}

