/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.password.policy.io.jsonp;

import com.covisint.core.support.constraint.Nonnull;
import com.covisint.platform.authn.core.password.policy.LifetimeRule;
import com.covisint.platform.authn.core.password.policy.io.jsonp.AbstractPasswordPolicyRuleReader;
import com.google.common.net.MediaType;
import javax.json.JsonObject;

public final class LifetimeRuleReader
extends AbstractPasswordPolicyRuleReader {
    private void assertKeyExists(JsonObject json, String key) {
        if (!json.containsKey((Object)key)) {
            throw new IllegalStateException(String.format("Expected JSON field %s not found.", key));
        }
    }

    @Override
    protected LifetimeRule createResource(MediaType mediaType) {
        return new LifetimeRule();
    }

    @Override
    protected LifetimeRule readResource(@Nonnull JsonObject ruleJson) {
        this.assertKeyExists(ruleJson, "minPasswordLifetime");
        this.assertKeyExists(ruleJson, "maxPasswordLifetime");
        LifetimeRule rule = new LifetimeRule();
        rule.setMinLifetime(ruleJson.getInt("minPasswordLifetime"));
        rule.setMaxLifetime(ruleJson.getInt("maxPasswordLifetime"));
        return rule;
    }

    @Nonnull
    public Class getResourceType() {
        return LifetimeRule.class;
    }

    public boolean isReadable(MediaType mediaType) {
        return true;
    }

    @Override
    public String getRuleType() {
        return "LIFETIME";
    }
}

